/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.ZyGraph.Menus;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Exceptions.MaybeNullException;
import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions.CGroupAction;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.NodeTaggingTree.CTagsTree;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.Actions.CActionCreateCommentNode;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.Actions.CActionEditComments;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.Actions.CActionSelectNodePredecessors;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.Actions.CActionSelectNodeSuccessors;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.Actions.CActionSelectSameFunctionType;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.Actions.CActionSelectSameParentFunction;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.Actions.CTagNodeAction;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.Actions.CTagSelectedNodesAction;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.INaviFunctionNode;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public final class CMenuBuilder {
    private CMenuBuilder() {
    }

    public static void addCommentMenu(JPopupMenu menu, CGraphModel model, INaviViewNode node) {
        Preconditions.checkNotNull(menu, "IE02140: Menu argument can not be null");
        Preconditions.checkNotNull(node, "IE02143: Node argument can not be null");
        menu.add(CActionProxy.proxy(new CActionEditComments(model, node)));
        menu.add(CActionProxy.proxy(new CActionCreateCommentNode(model.getParent(), model.getGraph().getRawView(), node)));
        menu.addSeparator();
    }

    public static void addSelectionMenus(JPopupMenu menu, ZyGraph graph, NaviNode node) {
        Preconditions.checkNotNull(menu, "IE02144: Menu argument can not be null");
        Preconditions.checkNotNull(graph, "IE02145: Graph argument can not be null");
        Preconditions.checkNotNull(node, "IE02146: Node argument can not be null");
        JMenu selectionMenu = new JMenu("Selection");
        selectionMenu.add(CActionProxy.proxy(new CActionSelectNodePredecessors(graph, node)));
        selectionMenu.add(CActionProxy.proxy(new CActionSelectNodeSuccessors(graph, node)));
        if (graph.getSelectedNodes().size() > 0) {
            selectionMenu.add(CActionProxy.proxy(new CGroupAction(graph)));
        }
        if (node.getRawNode() instanceof INaviCodeNode) {
            try {
                INaviFunction parentFunction = ((INaviCodeNode)node.getRawNode()).getParentFunction();
                selectionMenu.add(CActionProxy.proxy(new CActionSelectSameParentFunction(graph, parentFunction)));
            }
            catch (MaybeNullException parentFunction) {}
        } else if (node.getRawNode() instanceof INaviFunctionNode) {
            INaviFunction function = ((INaviFunctionNode)node.getRawNode()).getFunction();
            selectionMenu.add(CActionProxy.proxy(new CActionSelectSameFunctionType(graph, function.getType())));
        }
        menu.add(selectionMenu);
        menu.addSeparator();
    }

    public static void addTaggingMenu(JPopupMenu menu, CGraphModel model, NaviNode node) {
        Preconditions.checkNotNull(menu, "IE02147: Menu argument can not be null");
        Preconditions.checkNotNull(model, "IE02148: Model argument can not be null");
        Preconditions.checkNotNull(node, "IE02149: Node argument can not be null");
        JMenuItem tagNodeItem = new JMenuItem(CActionProxy.proxy(new CTagNodeAction(model.getParent(), model.getGraphPanel().getTagsTree(), node)));
        JMenuItem tagSelectedNodesItem = new JMenuItem(CActionProxy.proxy(new CTagSelectedNodesAction(model.getParent(), model.getGraphPanel().getTagsTree(), model.getGraph())));
        CTagsTree tree = model.getGraphPanel().getTagsTree();
        tagNodeItem.setEnabled(tree.getSelectionPath() != null);
        tagSelectedNodesItem.setEnabled(tree.getSelectionPath() != null && !model.getGraph().getSelectedNodes().isEmpty());
        menu.add(tagNodeItem);
        menu.add(tagSelectedNodesItem);
        menu.addSeparator();
    }
}

