/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.ZyGraph.Implementations;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.ZyGraph.Implementations.InternalNodeCallBack;
import com.google.security.zynamics.binnavi.disassembly.CCodeNodeHelpers;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviFunctionNode;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.INodeCallback;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.IViewNode;
import com.google.security.zynamics.zylib.types.common.IterationMode;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.functions.ZoomFunctions;

public final class ZyZoomHelpers {
    private ZyZoomHelpers() {
    }

    private static void uncollapseParents(IViewNode<?> node) {
        if (node.getParentGroup() != null) {
            ZyZoomHelpers.uncollapseParents(node.getParentGroup());
            node.getParentGroup().setCollapsed(false);
        }
    }

    static boolean zoomToAddress(ZyGraph graph, IAddress address, boolean animate, NaviNode node, INaviCodeNode codeNode) {
        for (INaviInstruction instruction : codeNode.getInstructions()) {
            if (!instruction.getAddress().equals(address)) continue;
            ZyZoomHelpers.uncollapseParents(codeNode);
            if (!node.isVisible()) {
                graph.showNode(node, true);
            }
            ZoomFunctions.zoomToNode(graph, node, CCodeNodeHelpers.instructionToLine(codeNode, instruction), animate);
            return true;
        }
        return false;
    }

    static boolean zoomToAddress(ZyGraph graph, IAddress address, NaviNode node, INaviFunctionNode functionNode) {
        if (functionNode.getFunction().getAddress().equals(address)) {
            ZyZoomHelpers.uncollapseParents(functionNode);
            if (!node.isVisible()) {
                graph.showNode(node, true);
            }
            ZoomFunctions.zoomToNode(graph, node);
            return true;
        }
        return false;
    }

    public static void zoomToAddress(final ZyGraph graph, final IAddress address) {
        graph.iterate(new INodeCallback<NaviNode>(){

            @Override
            public IterationMode next(NaviNode node) {
                INaviFunctionNode functionNode;
                if (node.getRawNode() instanceof INaviCodeNode) {
                    INaviCodeNode codeNode = (INaviCodeNode)node.getRawNode();
                    for (INaviInstruction instruction : codeNode.getInstructions()) {
                        if (!instruction.getAddress().equals(address)) continue;
                        ZyZoomHelpers.uncollapseParents(codeNode);
                        graph.showNode(node, true);
                        ZoomFunctions.zoomToNode(graph, node);
                        return IterationMode.STOP;
                    }
                } else if (node.getRawNode() instanceof INaviFunctionNode && (functionNode = (INaviFunctionNode)node.getRawNode()).getFunction().getAddress().equals(address)) {
                    ZyZoomHelpers.uncollapseParents(functionNode);
                    graph.showNode(node, true);
                    ZoomFunctions.zoomToNode(graph, node);
                    return IterationMode.STOP;
                }
                return IterationMode.CONTINUE;
            }
        });
    }

    public static boolean zoomToAddress(ZyGraph graph, IAddress address, INaviModule module, boolean animate) {
        Preconditions.checkNotNull(graph, "IE02105: Graph argument can not be null");
        Preconditions.checkNotNull(address, "IE02106: Address argument can not be null");
        InternalNodeCallBack callBack = new InternalNodeCallBack(module, graph, address, animate);
        graph.iterate(callBack);
        return callBack.nodeFound();
    }

    public static void zoomToInstruction(final ZyGraph graph, final INaviInstruction instruction) {
        graph.iterate(new INodeCallback<NaviNode>(){

            @Override
            public IterationMode next(NaviNode node) {
                INaviCodeNode codeNode;
                if (node.getRawNode() instanceof INaviCodeNode && (codeNode = (INaviCodeNode)node.getRawNode()).hasInstruction(instruction)) {
                    ZyZoomHelpers.uncollapseParents(codeNode);
                    graph.showNode(node, true);
                    ZoomFunctions.zoomToNode(graph, node);
                    return IterationMode.STOP;
                }
                return IterationMode.CONTINUE;
            }
        });
    }
}

