/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.ZyGraph;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.ZyGraph.Implementations.CGraphFunctions;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.GraphHelpers;
import com.google.security.zynamics.zylib.gui.zygraph.proximity.ProximityUpdater;
import com.google.security.zynamics.zylib.gui.zygraph.settings.CProximitySettingsAdapter;
import com.google.security.zynamics.zylib.gui.zygraph.settings.IProximitySettingsListener;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JFrame;

public final class CDefaultProximityUpdater
extends ProximityUpdater<NaviNode> {
    private final JFrame m_parent;
    private final ZyGraph m_graph;
    private final IProximitySettingsListener m_proximityListener = new InternalProximityListener();

    public CDefaultProximityUpdater(JFrame parent, ZyGraph graph) {
        super(graph);
        this.m_parent = Preconditions.checkNotNull(parent, "IE02100: Parent argument can not be null");
        this.m_graph = Preconditions.checkNotNull(graph, "IE02362: graph argument can not be null");
        this.m_graph.getSettings().getProximitySettings().addListener(this.m_proximityListener);
    }

    @Override
    protected void showNodes(Collection<NaviNode> selectedNodes, Collection<NaviNode> unselectedNodes) {
        CGraphFunctions.showNodes(this.m_parent, this.m_graph, selectedNodes, unselectedNodes);
    }

    public void dispose() {
        this.m_graph.getSettings().getProximitySettings().removeListener(this.m_proximityListener);
    }

    private class InternalProximityListener
    extends CProximitySettingsAdapter {
        private InternalProximityListener() {
        }

        private void showSelectedNodes() {
            Set<NaviNode> selectedNodes = CDefaultProximityUpdater.this.m_graph.getSelectedNodes();
            List<NaviNode> allNodes = GraphHelpers.getNodes(CDefaultProximityUpdater.this.m_graph);
            allNodes.removeAll(selectedNodes);
            CDefaultProximityUpdater.this.showNodes((Collection<NaviNode>)selectedNodes, (Collection<NaviNode>)allNodes);
        }

        @Override
        public void changedProximityBrowsingFrozen(boolean frozen) {
            if (CDefaultProximityUpdater.this.m_graph.getSettings().getProximitySettings().getProximityBrowsing() && !frozen) {
                this.showSelectedNodes();
            }
        }
    }
}

