/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.ZyGraph.Builders;

import com.google.security.zynamics.binnavi.Exceptions.MaybeNullException;
import com.google.security.zynamics.binnavi.ZyGraph.Builders.Modifiers.INodeModifier;
import com.google.security.zynamics.binnavi.ZyGraph.ZyGraphViewSettings;
import com.google.security.zynamics.binnavi.config.ColorsConfigItem;
import com.google.security.zynamics.binnavi.config.ConfigManager;
import com.google.security.zynamics.binnavi.debug.helpers.RelocationChecker;
import com.google.security.zynamics.binnavi.disassembly.CFunctionReplacement;
import com.google.security.zynamics.binnavi.disassembly.COperandTreeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.INaviOperandTree;
import com.google.security.zynamics.binnavi.disassembly.INaviOperandTreeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviReplacement;
import com.google.security.zynamics.binnavi.disassembly.OperandDisplayStyle;
import com.google.security.zynamics.binnavi.disassembly.UnrelocatedAddress;
import com.google.security.zynamics.binnavi.disassembly.types.TypeSubstitution;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.disassembly.ExpressionType;
import com.google.security.zynamics.zylib.disassembly.IReplacement;
import com.google.security.zynamics.zylib.disassembly.OperandOrderIterator;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.CStyleRunData;
import java.awt.Color;
import java.math.BigInteger;
import java.util.List;

public final class ZyOperandBuilder {
    private ZyOperandBuilder() {
    }

    private static void addClosingDelimiters(StringBuffer line, List<CStyleRunData> styleRuns, boolean hasMemderef, boolean hasExpressionList, boolean hasExclamationMark) {
        ColorsConfigItem colors2 = ConfigManager.instance().getColorSettings();
        if (hasMemderef) {
            styleRuns.add(new CStyleRunData(line.length(), 1, colors2.getMemRefColor()));
            line.append(']');
        }
        if (hasExpressionList) {
            styleRuns.add(new CStyleRunData(line.length(), 1, colors2.getExpressionListColor()));
            line.append('}');
        }
        if (hasExclamationMark) {
            styleRuns.add(new CStyleRunData(line.length(), 1, colors2.getOperatorColor()));
            line.append('!');
        }
    }

    private static void addCommaSeparator(StringBuffer line, List<CStyleRunData> styleRuns, List<? extends INaviOperandTree> operands, int operandIndex) {
        if (operandIndex < operands.size() - 1) {
            styleRuns.add(new CStyleRunData(line.length(), 2, ConfigManager.instance().getColorSettings().getOperandSeparatorColor()));
            line.append(", ");
        }
    }

    private static void addOperand(StringBuffer line, List<CStyleRunData> styleRuns, COperandTreeNode treeNode, INodeModifier modifier) {
        INaviReplacement replacement;
        ColorsConfigItem colors2 = ConfigManager.instance().getColorSettings();
        String typeSubstitution = ZyOperandBuilder.getTypeSubstitution(treeNode);
        if (!typeSubstitution.isEmpty()) {
            styleRuns.add(new CStyleRunData(line.length(), typeSubstitution.length(), colors2.getVariableColor(), treeNode));
            line.append(typeSubstitution);
            return;
        }
        INaviReplacement iNaviReplacement = replacement = treeNode.getDisplayStyle() == OperandDisplayStyle.OFFSET ? treeNode.getReplacement() : null;
        if (replacement == null) {
            Color color = ZyOperandBuilder.getOperandColor(treeNode.getType());
            String value = ZyOperandBuilder.adjustValue(treeNode, modifier);
            styleRuns.add(new CStyleRunData(line.length(), value.length(), color, treeNode));
            line.append(value);
        } else {
            String replacementString = ZyOperandBuilder.determineReplacementString(treeNode, replacement);
            if (replacementString.equalsIgnoreCase("")) {
                Color color = ZyOperandBuilder.getOperandColor(treeNode.getType());
                String value = ZyOperandBuilder.adjustValue(treeNode, modifier);
                styleRuns.add(new CStyleRunData(line.length(), value.length(), color, treeNode));
                line.append(value);
                return;
            }
            if (treeNode.getType() == ExpressionType.IMMEDIATE_INTEGER) {
                if (replacement instanceof CFunctionReplacement) {
                    styleRuns.add(new CStyleRunData(line.length(), replacementString.length(), colors2.getFunctionColor(), treeNode));
                } else {
                    styleRuns.add(new CStyleRunData(line.length(), replacementString.length(), colors2.getVariableColor(), treeNode));
                }
            } else {
                Color color = ZyOperandBuilder.getOperandColor(treeNode.getType());
                styleRuns.add(new CStyleRunData(line.length(), replacementString.length(), color, treeNode));
            }
            line.append(replacementString);
        }
    }

    private static String adjustValue(COperandTreeNode treeNode, INodeModifier modifier) {
        if (treeNode.getType() == ExpressionType.IMMEDIATE_INTEGER) {
            return ZyOperandBuilder.buildIntegerOperand(treeNode, modifier);
        }
        if (treeNode.getType() == ExpressionType.SIZE_PREFIX) {
            return String.valueOf(treeNode.getValue()).concat(" ");
        }
        return treeNode.getValue();
    }

    private static String getUnsignedBigIntegerString(BigInteger value, COperandTreeNode node, int radix) {
        if (value.signum() != -1) {
            return value.toString(radix);
        }
        INaviOperandTreeNode currentNode = node.getParent();
        while (currentNode.getType() != ExpressionType.SIZE_PREFIX) {
            if (currentNode.getParent() == null) {
                throw new IllegalStateException("Error: could not determine size of operand.");
            }
            currentNode = currentNode.getParent();
        }
        BigInteger twosComplement = value.abs().not().add(BigInteger.ONE);
        switch (currentNode.getValue()) {
            case "byte": {
                return twosComplement.and(new BigInteger("FF", 16)).toString(radix);
            }
            case "word": {
                return twosComplement.and(new BigInteger("FFFF", 16)).toString(radix);
            }
            case "dword": {
                return twosComplement.and(new BigInteger("FFFFFFFF", 16)).toString(radix);
            }
            case "fword": {
                return twosComplement.and(new BigInteger("FFFFFFFFFFFF", 16)).toString(radix);
            }
            case "qword": {
                return twosComplement.and(new BigInteger("FFFFFFFFFFFFFFFF", 16)).toString(radix);
            }
            case "oword": {
                return twosComplement.and(new BigInteger("FFFFFFFFFFFFFFFFFFFF", 16)).toString(radix);
            }
        }
        throw new IllegalStateException("Error: size of operand tree node is not supported.");
    }

    private static String buildIntegerOperand(COperandTreeNode operandTreeNode, INodeModifier nodeModifier) {
        BigInteger treeNodeValue = new BigInteger(operandTreeNode.getValue());
        if (nodeModifier != null && RelocationChecker.needsRelocation(operandTreeNode, operandTreeNode.getOperand().getInstruction().getModule())) {
            treeNodeValue = ZyOperandBuilder.relocateIntegerOperand(operandTreeNode, nodeModifier, treeNodeValue);
        }
        return ZyOperandBuilder.buildIntegerOperandString(operandTreeNode, treeNodeValue);
    }

    private static BigInteger relocateIntegerOperand(COperandTreeNode operandTreeNode, INodeModifier nodeModifier, BigInteger treeNodeValue) {
        return new BigInteger(nodeModifier.getAddress(operandTreeNode.getOperand().getInstruction().getModule(), new UnrelocatedAddress(new CAddress(treeNodeValue)), false), 16);
    }

    private static String buildIntegerOperandString(COperandTreeNode operandTreeNode, BigInteger treeNodeValue) {
        switch (operandTreeNode.getDisplayStyle()) {
            case CHAR: {
                return ZyOperandBuilder.bigIntegerToAsciiString(treeNodeValue);
            }
            case OFFSET: {
                break;
            }
            case SIGNED_DECIMAL: {
                return String.valueOf(treeNodeValue.toString(10)).concat("d");
            }
            case SIGNED_HEXADECIMAL: {
                return String.valueOf(treeNodeValue.toString(16)).concat("h");
            }
            case BINARY: {
                return String.valueOf(treeNodeValue.toString(2)).concat("b");
            }
            case UNSIGNED_DECIMAL: {
                return String.valueOf(ZyOperandBuilder.getUnsignedBigIntegerString(treeNodeValue, operandTreeNode, 10)).concat("d");
            }
            case UNSIGNED_HEXADECIMAL: {
                return String.valueOf(ZyOperandBuilder.getUnsignedBigIntegerString(treeNodeValue, operandTreeNode, 16)).concat("h");
            }
            case OCTAL: {
                return String.valueOf(ZyOperandBuilder.getUnsignedBigIntegerString(treeNodeValue, operandTreeNode, 8)).concat("o");
            }
            default: {
                return operandTreeNode.getValue();
            }
        }
        return operandTreeNode.getValue();
    }

    private static String bigIntegerToAsciiString(BigInteger bigInteger) {
        byte[] byteArray = bigInteger.toByteArray();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < byteArray.length; ++i2) {
            char value = (char)(byteArray[i2] & 0xFF);
            if (i2 == 0 && value == '\u0000') continue;
            stringBuffer.append(value);
        }
        return stringBuffer.toString();
    }

    private static void buildOperand(INaviInstruction instruction, INaviOperandTree operandTree, ZyGraphViewSettings graphSettings, StringBuffer line, List<CStyleRunData> styleRun, INodeModifier modifier, int counter) {
        OperandOrderIterator iter = new OperandOrderIterator(operandTree.getRootNode());
        boolean isVariableAccess = graphSettings.getDisplaySettings().getSimplifiedVariableAccess() && ZyOperandBuilder.isVariableAccess(operandTree.getRootNode());
        boolean hasMemderef = false;
        boolean hasExpressionList = false;
        boolean needsComma = false;
        boolean hasExclamationMark = false;
        COperandTreeNode memParent = null;
        ColorsConfigItem colors2 = ConfigManager.instance().getColorSettings();
        while (iter.next()) {
            if (isVariableAccess) {
                ZyOperandBuilder.skipMemoryAccess(iter);
            }
            COperandTreeNode treeNode = (COperandTreeNode)iter.current();
            hasExclamationMark = "!".equals(treeNode.getValue());
            if (ZyOperandBuilder.skipOperand(treeNode, hasExpressionList)) continue;
            if (needsComma) {
                styleRun.add(new CStyleRunData(line.length(), 1, colors2.getOperandSeparatorColor()));
                line.append(',');
            }
            if (hasExpressionList) {
                needsComma = true;
            }
            if (hasMemderef && !ZyOperandBuilder.isAncestor(treeNode, memParent)) {
                styleRun.add(new CStyleRunData(line.length(), 1, colors2.getMemRefColor()));
                line.append(']');
                hasMemderef = false;
            }
            boolean bl2 = hasExpressionList = treeNode.getType() == ExpressionType.EXPRESSION_LIST || hasExpressionList;
            if (treeNode.getType() == ExpressionType.MEMDEREF) {
                memParent = treeNode;
                hasMemderef = true;
            }
            ZyOperandBuilder.addOperand(line, styleRun, treeNode, modifier);
        }
        ZyOperandBuilder.addClosingDelimiters(line, styleRun, hasMemderef, hasExpressionList, hasExclamationMark);
        ZyOperandBuilder.addCommaSeparator(line, styleRun, instruction.getOperands(), counter);
    }

    private static String determineReplacementString(COperandTreeNode treeNode, IReplacement replacement) {
        if (!treeNode.getTypeInstanceReferences().isEmpty()) {
            return treeNode.getTypeInstanceReferences().get(0).getTypeInstance().getName();
        }
        return replacement.toString();
    }

    private static String getImmediateSubstitution(COperandTreeNode treeNode) {
        INaviOperandTreeNode otherChild;
        INaviOperandTreeNode parent = treeNode.getParent();
        if (parent != null && parent.getValue().equals("+") && (otherChild = ZyOperandBuilder.getSibling(treeNode)) != null && otherChild.getTypeSubstitution() != null) {
            long operandValue = Long.parseLong(treeNode.getValue());
            return TypeSubstitution.generateTypeString(otherChild.getTypeSubstitution(), operandValue);
        }
        return "";
    }

    private static INaviOperandTreeNode getMemoryAccessNode(INaviOperandTreeNode node) throws MaybeNullException {
        switch (node.getType()) {
            case SYMBOL: 
            case IMMEDIATE_INTEGER: 
            case REGISTER: 
            case IMMEDIATE_FLOAT: 
            case EXPRESSION_LIST: {
                throw new MaybeNullException();
            }
            case OPERATOR: {
                if (node.getChildren().size() == 1) {
                    return ZyOperandBuilder.getMemoryAccessNode(node.getChildren().get(0));
                }
                throw new MaybeNullException();
            }
            case MEMDEREF: {
                return node;
            }
            case SIZE_PREFIX: {
                return ZyOperandBuilder.getMemoryAccessNode(node.getChildren().get(0));
            }
        }
        throw new IllegalArgumentException("IE00702: Unknown node type");
    }

    private static Color getOperandColor(ExpressionType type) {
        switch (type) {
            case IMMEDIATE_INTEGER: {
                return ConfigManager.instance().getColorSettings().getImmediateColor();
            }
            case MEMDEREF: {
                return ConfigManager.instance().getColorSettings().getMemRefColor();
            }
            case OPERATOR: {
                return ConfigManager.instance().getColorSettings().getOperatorColor();
            }
            case SIZE_PREFIX: {
                return ConfigManager.instance().getColorSettings().getPrefixColor();
            }
            case SYMBOL: {
                return ConfigManager.instance().getColorSettings().getStringColor();
            }
            case REGISTER: {
                return ConfigManager.instance().getColorSettings().getRegisterColor();
            }
            case EXPRESSION_LIST: {
                return ConfigManager.instance().getColorSettings().getExpressionListColor();
            }
            case IMMEDIATE_FLOAT: {
                return ConfigManager.instance().getColorSettings().getImmediateColor();
            }
        }
        throw new IllegalStateException("IE02247: Unknown expression type");
    }

    private static String getRegisterSubstitution(COperandTreeNode node) {
        if (node.getTypeSubstitution() != null && node.getParent() != null && node.getParent().getChildren().size() == 1) {
            return String.format("%s %s", TypeSubstitution.generateTypeString(node.getTypeSubstitution(), 0L), node.getValue());
        }
        return "";
    }

    private static INaviOperandTreeNode getSibling(INaviOperandTreeNode node) {
        INaviOperandTreeNode parent = node.getParent();
        if (parent.getChildren().size() != 2) {
            return null;
        }
        return parent.getChildren().get(0) == node ? parent.getChildren().get(1) : parent.getChildren().get(0);
    }

    private static String getTypeSubstitution(COperandTreeNode treeNode) {
        switch (treeNode.getType()) {
            case IMMEDIATE_INTEGER: {
                return ZyOperandBuilder.getImmediateSubstitution(treeNode);
            }
            case REGISTER: {
                return ZyOperandBuilder.getRegisterSubstitution(treeNode);
            }
        }
        return "";
    }

    private static boolean isAncestor(COperandTreeNode child, COperandTreeNode parent) {
        if (child == parent) {
            return true;
        }
        if (child.getParent() == null) {
            return false;
        }
        return ZyOperandBuilder.isAncestor((COperandTreeNode)child.getParent(), parent);
    }

    private static boolean isOperatorVariableAccess(INaviOperandTreeNode node) {
        List<INaviOperandTreeNode> children = node.getChildren();
        if (children.size() == 2) {
            INaviOperandTreeNode child0 = children.get(0);
            INaviOperandTreeNode child1 = children.get(1);
            return ZyOperandBuilder.isVariable(child0) ^ ZyOperandBuilder.isVariable(child1);
        }
        return false;
    }

    private static boolean isVariable(INaviOperandTreeNode node) {
        return node.getType() == ExpressionType.IMMEDIATE_INTEGER && node.getReplacement() != null && node.getDisplayStyle() == OperandDisplayStyle.OFFSET;
    }

    private static boolean isVariableAccess(INaviOperandTreeNode node) {
        try {
            INaviOperandTreeNode memoryAccessNode = ZyOperandBuilder.getMemoryAccessNode(node);
            List<INaviOperandTreeNode> children = memoryAccessNode.getChildren();
            if (children.size() == 1) {
                INaviOperandTreeNode child = children.get(0);
                switch (child.getType()) {
                    case SIZE_PREFIX: {
                        return ZyOperandBuilder.isVariable(child.getChildren().get(0));
                    }
                    case IMMEDIATE_INTEGER: {
                        return ZyOperandBuilder.isVariable(child);
                    }
                    case OPERATOR: {
                        return ZyOperandBuilder.isOperatorVariableAccess(child);
                    }
                }
                return false;
            }
            throw new IllegalStateException("IE00703: Invalid tree shape");
        }
        catch (MaybeNullException e2) {
            return false;
        }
    }

    private static void skipMemoryAccess(OperandOrderIterator iter) {
        do {
            if (iter.current().getType() != ExpressionType.MEMDEREF) continue;
            iter.next();
            while (iter.current().getType() != ExpressionType.IMMEDIATE_INTEGER) {
                iter.next();
            }
            return;
        } while (iter.next());
    }

    private static boolean skipOperand(COperandTreeNode treeNode, boolean hasExpressionList) {
        if ("!".equals(treeNode.getValue())) {
            return true;
        }
        if ("dword".equals(treeNode.getValue())) {
            return true;
        }
        return hasExpressionList && treeNode.getType() == ExpressionType.EXPRESSION_LIST;
    }

    public static void buildOperands(INaviInstruction instruction, ZyGraphViewSettings graphSettings, StringBuffer line, List<CStyleRunData> styleRun, INodeModifier modifier) {
        int counter = 0;
        for (INaviOperandTree iNaviOperandTree : instruction.getOperands()) {
            ZyOperandBuilder.buildOperand(instruction, iNaviOperandTree, graphSettings, line, styleRun, modifier, counter);
            ++counter;
        }
    }
}

