/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.ZyGraph.Builders;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.ZyGraph.Builders.CommentContainer;
import com.google.security.zynamics.binnavi.ZyGraph.Builders.Wrappers.CGlobalEdgeCommentWrapper;
import com.google.security.zynamics.binnavi.ZyGraph.Builders.Wrappers.CGlobalNodeCommentWrapper;
import com.google.security.zynamics.binnavi.ZyGraph.Builders.Wrappers.CLocalEdgeCommentWrapper;
import com.google.security.zynamics.binnavi.ZyGraph.Builders.Wrappers.CLocalNodeCommentWrapper;
import com.google.security.zynamics.binnavi.config.ColorsConfigItem;
import com.google.security.zynamics.binnavi.config.ConfigManager;
import com.google.security.zynamics.binnavi.disassembly.INaviEdge;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLabelContent;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLineContent;
import java.awt.Color;
import java.awt.Font;
import java.util.Iterator;
import java.util.List;

public final class ZyNodeBuilder {
    private static final Font ITALIC_FONT = new Font(GuiHelper.getMonospaceFont(), 2, 12);
    private static final Font ITALIC_BOLD_FONT = new Font(GuiHelper.getMonospaceFont(), 3, 12);

    private ZyNodeBuilder() {
    }

    private static void addCommentLines(ZyLabelContent content, INaviViewNode node, List<IComment> localComment, List<IComment> globalComment) {
        Preconditions.checkNotNull(content, "IE01530: Content argument can't be null");
        ColorsConfigItem colorSettings = ConfigManager.instance().getColorSettings();
        if (localComment != null) {
            ZyNodeBuilder.addCommentLines(content, localComment, colorSettings.getLocalCommentColor(), new CLocalNodeCommentWrapper(node));
        }
        if (globalComment != null) {
            ZyNodeBuilder.addCommentLines(content, globalComment, colorSettings.getGlobalCommentColor(), new CGlobalNodeCommentWrapper(node));
        }
    }

    private static void addCommentLines(ZyLabelContent content, List<IComment> comments, Color color, Object object) {
        Preconditions.checkNotNull(content, "IE01180: Content argument can't be null");
        Preconditions.checkNotNull(comments, "IE01181: Comment argument can not be null");
        Preconditions.checkNotNull(color, "IE01183: Color argument can not be null");
        Preconditions.checkNotNull(object, "IE01191: Object argument can not be null");
        for (IComment comment : comments) {
            CommentContainer currentCommentContainer = new CommentContainer(comment);
            for (String commentString : currentCommentContainer.getCommentingString()) {
                ZyLineContent lineContent = new ZyLineContent(commentString, ITALIC_FONT, null);
                lineContent.setTextColor(Color.BLACK);
                lineContent.setObject(0, commentString.length(), object);
                if (commentString.equals(currentCommentContainer.getCommentingString().get(0))) {
                    lineContent.setTextColor(0, currentCommentContainer.getCommentUserNameLength(), currentCommentContainer.getCommentColor());
                }
                content.addLineContent(lineContent);
            }
        }
    }

    private static void addTagLines(ZyLabelContent content, INaviViewNode node, String prefix, Color color) {
        Preconditions.checkNotNull(content, "IE00918: Content argument can't be null");
        Preconditions.checkNotNull(node, "IE00919: Node argument can't be null");
        Preconditions.checkNotNull(color, "IE00920: Color argument can't be null");
        Iterator<CTag> it = node.getTagsIterator();
        while (it.hasNext()) {
            CTag tag = it.next();
            if ("".equals(tag.getName())) continue;
            String string2 = String.valueOf(prefix);
            String string3 = String.valueOf(tag.getName());
            ZyLineContent lineComment = new ZyLineContent(string3.length() != 0 ? string2.concat(string3) : new String(string2), null);
            lineComment.setTextColor(color);
            lineComment.setFont(ITALIC_BOLD_FONT);
            content.addLineContent(lineComment);
        }
    }

    public static void addCommentLines(ZyLabelContent content, INaviEdge edge, List<IComment> localComment, List<IComment> globalComment) {
        Preconditions.checkNotNull(content, "IE00914: Content argument can't be null");
        ColorsConfigItem colors2 = ConfigManager.instance().getColorSettings();
        if (localComment != null) {
            ZyNodeBuilder.addCommentLines(content, localComment, colors2.getLocalCommentColor(), new CLocalEdgeCommentWrapper(edge));
        }
        if (globalComment != null) {
            ZyNodeBuilder.addCommentLines(content, globalComment, colors2.getGlobalCommentColor(), new CGlobalEdgeCommentWrapper(edge));
        }
    }

    public static void addCommentTagLines(ZyLabelContent content, INaviViewNode node, List<IComment> localComment, List<IComment> globalComment) {
        ZyNodeBuilder.addCommentLines(content, node, localComment, globalComment);
        ZyNodeBuilder.addTagLines(content, node, "|T| ", ConfigManager.instance().getColorSettings().getTagColor());
    }
}

