/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.ZyGraph.Builders;

import com.google.common.base.Strings;
import com.google.security.zynamics.binnavi.ZyGraph.Builders.Modifiers.INodeModifier;
import com.google.security.zynamics.binnavi.ZyGraph.Builders.ZyOperandBuilder;
import com.google.security.zynamics.binnavi.ZyGraph.ZyGraphViewSettings;
import com.google.security.zynamics.binnavi.config.ConfigManager;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.CStyleRunData;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public final class ZyInstructionBuilder {
    private static final String PADDING_AFTER_ADDRESS = "   ";
    private static final int MINIMUM_MNEMONIC_SIZE = 12;

    private ZyInstructionBuilder() {
    }

    private static void buildAddress(INaviInstruction instruction, StringBuffer line, List<CStyleRunData> styleRun, INodeModifier modifier) {
        String normalAddress = instruction.getAddress().toHexString();
        String address = modifier == null ? normalAddress : modifier.getAddress(instruction);
        line.append(address);
        if (address.equals(normalAddress)) {
            styleRun.add(new CStyleRunData(0, address.length(), ConfigManager.instance().getColorSettings().getAddressColor()));
        } else {
            styleRun.add(new CStyleRunData(0, address.length(), Color.RED));
        }
        line.append(PADDING_AFTER_ADDRESS);
    }

    private static void buildMnemonic(IInstruction instruction, StringBuffer line, List<CStyleRunData> styleRun) {
        String mnemonic = instruction.getMnemonic();
        styleRun.add(new CStyleRunData(line.length(), mnemonic.length(), ConfigManager.instance().getColorSettings().getMnemonicColor()));
        line.append(Strings.padEnd(mnemonic, 12, ' '));
    }

    public static Pair<String, List<CStyleRunData>> buildInstructionLine(INaviInstruction instruction, ZyGraphViewSettings graphSettings, INodeModifier modifier) {
        ArrayList<CStyleRunData> styleRun = new ArrayList<CStyleRunData>();
        StringBuffer line = new StringBuffer();
        ZyInstructionBuilder.buildAddress(instruction, line, styleRun, modifier);
        ZyInstructionBuilder.buildMnemonic(instruction, line, styleRun);
        ZyOperandBuilder.buildOperands(instruction, graphSettings, line, styleRun, modifier);
        return new Pair<String, List<CStyleRunData>>(line.toString(), styleRun);
    }
}

