/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.ZyGraph.Builders;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Exceptions.MaybeNullException;
import com.google.security.zynamics.binnavi.ZyGraph.Builders.IGraphBuilderManagerListener;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.Builders.ZyGraphBuilder;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.util.HashMap;
import java.util.Map;

public final class ZyGraphBuilderManager {
    private static final ZyGraphBuilderManager m_instance = new ZyGraphBuilderManager();
    private final Map<INaviView, ZyGraphBuilder> m_builders = new HashMap<INaviView, ZyGraphBuilder>();
    private final ListenerProvider<IGraphBuilderManagerListener> m_listeners = new ListenerProvider();

    private ZyGraphBuilderManager() {
    }

    public static ZyGraphBuilderManager instance() {
        return m_instance;
    }

    public void addListener(IGraphBuilderManagerListener listener) {
        this.m_listeners.addListener(listener);
    }

    public ZyGraphBuilder getBuilder(INaviView view) throws MaybeNullException {
        ZyGraphBuilder builder = this.m_builders.get(view);
        if (builder == null) {
            throw new MaybeNullException();
        }
        return builder;
    }

    public void removeBuilder(INaviView view) {
        ZyGraphBuilder builder = this.m_builders.get(view);
        Preconditions.checkNotNull(builder, "IE00704: View was not managed");
        this.m_builders.remove(view);
        for (IGraphBuilderManagerListener listener : this.m_listeners) {
            try {
                listener.removedBuilder(view, builder);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void removeListener(IGraphBuilderManagerListener listener) {
        this.m_listeners.removeListener(listener);
    }

    public void setBuilder(INaviView view, ZyGraphBuilder builder) {
        this.m_builders.put(view, builder);
        for (IGraphBuilderManagerListener listener : this.m_listeners) {
            try {
                listener.addedBuilder(view, builder);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }
}

