/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.ZyGraph.Builders;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.security.zynamics.binnavi.Exceptions.MaybeNullException;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.ZyGraph.Builders.CommentContainer;
import com.google.security.zynamics.binnavi.ZyGraph.Builders.Modifiers.INodeModifier;
import com.google.security.zynamics.binnavi.ZyGraph.Builders.ZyInstructionBuilder;
import com.google.security.zynamics.binnavi.ZyGraph.Builders.ZyNodeBuilder;
import com.google.security.zynamics.binnavi.ZyGraph.ZyGraphViewSettings;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.UnrelocatedAddress;
import com.google.security.zynamics.binnavi.disassembly.algorithms.CReferenceFinder;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.CStyleRunData;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ECommentPlacement;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.IZyEditableObject;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLabelContent;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLineContent;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class ZyCodeNodeBuilder {
    private static final Font BOLD_FONT = new Font(GuiHelper.getMonospaceFont(), 1, 12);
    private static final Font ITALIC_FONT = new Font(GuiHelper.getMonospaceFont(), 2, 12);
    private static final Font NORMAL_FONT = new Font(GuiHelper.getMonospaceFont(), 0, 12);
    private static final String PADDING_AFTER_FUNCTION_ADDRESS = "   ";

    private ZyCodeNodeBuilder() {
    }

    private static void buildFunctionLine(INaviCodeNode node, ZyLabelContent content, INodeModifier modifier) {
        try {
            INaviFunction parentFunction = node.getParentFunction();
            String address = modifier == null ? parentFunction.getAddress().toHexString() : modifier.getAddress(parentFunction.getModule(), new UnrelocatedAddress(parentFunction.getAddress()), true);
            String name = parentFunction.getName();
            String string2 = String.valueOf(PADDING_AFTER_FUNCTION_ADDRESS);
            String string3 = parentFunction.getModule().getConfiguration().getName();
            content.addLineContent(new ZyLineContent(new StringBuilder(2 + String.valueOf(address).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(name).length()).append(address).append(string2).append(string3).append("::").append(name).toString(), BOLD_FONT, Lists.newArrayList(new CStyleRunData(0, -1, Color.BLACK)), null));
        }
        catch (MaybeNullException maybeNullException) {
            // empty catch block
        }
    }

    private static void buildInstructionLines(INaviCodeNode node, ZyLabelContent content, ZyGraphViewSettings graphSettings, INodeModifier modifier) {
        ArrayList<Pair<String, List<CStyleRunData>>> lines = new ArrayList<Pair<String, List<CStyleRunData>>>();
        HashMap<Pair<String, List<CStyleRunData>>, ArrayList<CommentContainer>> comments = new HashMap<Pair<String, List<CStyleRunData>>, ArrayList<CommentContainer>>();
        int maxLine = ZyCodeNodeBuilder.createLines(node, lines, comments, graphSettings, modifier);
        ZyCodeNodeBuilder.insertLines(content, lines, comments, maxLine);
        ZyNodeBuilder.addCommentTagLines(content, node, node.getComments().getLocalCodeNodeComment(), node.getComments().getGlobalCodeNodeComment());
    }

    private static int createLines(INaviCodeNode node, List<Pair<String, List<CStyleRunData>>> lines, HashMap<Pair<String, List<CStyleRunData>>, ArrayList<CommentContainer>> commentsToLineAssociation, ZyGraphViewSettings graphSettings, INodeModifier modifier) {
        int maxLineWidth = 0;
        HashMap<INaviInstruction, INaviFunction> instructionToFunctionReferences = CReferenceFinder.getCodeReferenceMap(node);
        for (INaviInstruction instruction : node.getInstructions()) {
            List<IComment> list;
            List<IComment> globalComments;
            Pair<String, List<CStyleRunData>> zyLineContent = ZyInstructionBuilder.buildInstructionLine(instruction, graphSettings, modifier);
            ArrayList<CommentContainer> commentLineContainerList = new ArrayList<CommentContainer>();
            List<IComment> localComments = node.getComments().getLocalInstructionComment(instruction);
            if (localComments != null) {
                for (IComment iComment : localComments) {
                    commentLineContainerList.add(new CommentContainer(iComment));
                }
            }
            if ((globalComments = instruction.getGlobalComment()) != null) {
                for (Object globalComment : globalComments) {
                    commentLineContainerList.add(new CommentContainer((IComment)globalComment));
                }
            }
            List<IComment> list2 = list = instructionToFunctionReferences.get(instruction) == null ? null : ((INaviFunction)instructionToFunctionReferences.get(instruction)).getGlobalComment();
            if (list != null) {
                Object globalComment;
                globalComment = list.iterator();
                while (globalComment.hasNext()) {
                    IComment functionComment = (IComment)globalComment.next();
                    commentLineContainerList.add(new CommentContainer(functionComment));
                }
            }
            commentsToLineAssociation.put(zyLineContent, commentLineContainerList);
            int lineWidth = zyLineContent.first().length();
            if (lineWidth > maxLineWidth) {
                maxLineWidth = lineWidth;
            }
            lines.add(zyLineContent);
        }
        return maxLineWidth;
    }

    private static void insertLines(ZyLabelContent content, List<Pair<String, List<CStyleRunData>>> lines, HashMap<Pair<String, List<CStyleRunData>>, ArrayList<CommentContainer>> comments, int maxLineWidth) {
        for (Pair<String, List<CStyleRunData>> lineContent : lines) {
            String instructionFirstCommentLine;
            ArrayList<CommentContainer> instructionComments = comments.get(lineContent);
            StringBuilder lineBuilder = new StringBuilder(lineContent.first());
            List<CStyleRunData> styleRuns = lineContent.second();
            if (instructionComments == null || instructionComments.isEmpty()) {
                ZyLineContent instructionLine = new ZyLineContent(lineBuilder.toString(), NORMAL_FONT, styleRuns, null);
                content.addLineContent(instructionLine);
                continue;
            }
            String string2 = instructionFirstCommentLine = instructionComments.get(0).getCommentingString() != null ? instructionComments.get(0).getCommentingString().get(0) : null;
            if (instructionFirstCommentLine != null) {
                lineBuilder.append(Strings.repeat(" ", maxLineWidth - lineBuilder.length() + 1));
                lineBuilder.append(instructionFirstCommentLine);
            }
            ZyLineContent instructionLine = new ZyLineContent(lineBuilder.toString(), NORMAL_FONT, styleRuns, null);
            if (instructionFirstCommentLine != null) {
                instructionLine.setFont(maxLineWidth + 1, instructionFirstCommentLine.length(), ITALIC_FONT);
                instructionLine.setTextColor(maxLineWidth + 1, instructionFirstCommentLine.length(), Color.BLACK);
                instructionLine.setTextColor(maxLineWidth + 1, instructionComments.get(0).getCommentUserNameLength(), instructionComments.get(0).getCommentColor());
            }
            content.addLineContent(instructionLine);
            boolean firstCommentContainer = true;
            for (CommentContainer commentContainer : instructionComments) {
                boolean firstCommentLine = true;
                for (String partialCommentString : commentContainer.getCommentingString()) {
                    if (firstCommentContainer) {
                        firstCommentContainer = false;
                        continue;
                    }
                    String string3 = String.valueOf(Strings.repeat(" ", maxLineWidth + 1));
                    String string4 = String.valueOf(partialCommentString);
                    ZyLineContent commentLine = new ZyLineContent(string4.length() != 0 ? string3.concat(string4) : new String(string3), ITALIC_FONT, null);
                    commentLine.setTextColor(Color.BLACK);
                    if (firstCommentLine) {
                        firstCommentLine = false;
                        commentLine.setTextColor(maxLineWidth + 1, commentContainer.getCommentUserNameLength(), commentContainer.getCommentColor());
                    }
                    content.addLineContent(commentLine);
                }
            }
        }
    }

    public static ZyLabelContent buildContent(INaviCodeNode node, ZyGraphViewSettings graphSettings, INodeModifier modifier) {
        Preconditions.checkNotNull(node, "IE00897: Node argument can not be null");
        ZyLabelContent content = new ZyLabelContent(new IZyEditableObject(){

            @Override
            public int getEnd() {
                throw new IllegalStateException();
            }

            @Override
            public int getLength() {
                throw new IllegalStateException();
            }

            @Override
            public Object getPersistentModel() {
                throw new IllegalStateException();
            }

            @Override
            public int getStart() {
                throw new IllegalStateException();
            }

            @Override
            public boolean isCommentDelimiter() {
                throw new IllegalStateException();
            }

            @Override
            public boolean isPlaceholder() {
                throw new IllegalStateException();
            }

            @Override
            public boolean update(String newContent) {
                throw new IllegalStateException();
            }

            @Override
            public boolean updateComment(String newContent, ECommentPlacement placement) {
                throw new IllegalStateException();
            }
        }, true, false);
        ZyCodeNodeBuilder.buildContent(content, node, graphSettings, modifier);
        return content;
    }

    public static void buildContent(ZyLabelContent content, INaviCodeNode node, ZyGraphViewSettings graphSettings, INodeModifier modifier) {
        Preconditions.checkNotNull(node, "IE01533: Node argument can not be null");
        while (content.getLineCount() != 0) {
            content.removeLine(0);
        }
        ZyCodeNodeBuilder.buildFunctionLine(node, content, modifier);
        ZyCodeNodeBuilder.buildInstructionLines(node, content, graphSettings, modifier);
    }
}

