/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Tutorials;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Tutorials.CTutorialStep;
import com.google.security.zynamics.binnavi.Tutorials.ITutorialListener;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class CTutorial {
    private final String m_name;
    private final String m_description;
    private final List<CTutorialStep> m_steps;
    private final ListenerProvider<ITutorialListener> m_listeners = new ListenerProvider();
    private int m_stepCounter = 0;

    public CTutorial(String name, String description, List<CTutorialStep> steps) {
        this.m_name = Preconditions.checkNotNull(name, "IE00998: Name argument can not be null");
        this.m_description = Preconditions.checkNotNull(description, "IE00999: Description argument can not be null");
        this.m_steps = new ArrayList<CTutorialStep>((Collection)Preconditions.checkNotNull(steps, "IE01000: Steps argument can not be null"));
        Preconditions.checkArgument(!steps.isEmpty(), "IE01001: Tutorials with no steps are not allowed");
    }

    public void addListener(ITutorialListener listener) {
        this.m_listeners.addListener(listener);
    }

    public CTutorialStep getCurrentStep() {
        return this.m_steps.get(this.m_stepCounter);
    }

    public String getDescription() {
        return this.m_description;
    }

    public String getName() {
        return this.m_name;
    }

    public int getStepCount() {
        return this.m_steps.size();
    }

    public int getStepCounter() {
        return this.m_stepCounter;
    }

    public void next() {
        ++this.m_stepCounter;
        if (this.m_stepCounter == this.m_steps.size()) {
            for (ITutorialListener listener : this.m_listeners) {
                listener.finished(this);
            }
        } else {
            for (ITutorialListener listener : this.m_listeners) {
                listener.changedStep(this);
            }
        }
    }

    public void removeListener(ITutorialListener listener) {
        this.m_listeners.removeListener(listener);
    }

    public void start() {
        this.m_stepCounter = 0;
        for (ITutorialListener listener : this.m_listeners) {
            listener.started(this);
        }
    }

    public String toString() {
        return this.getName();
    }
}

