/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Tagging;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.Tagging.ITagManager;
import com.google.security.zynamics.binnavi.Tagging.ITagManagerListener;
import com.google.security.zynamics.binnavi.Tagging.TagType;
import com.google.security.zynamics.binnavi.disassembly.IDatabaseObject;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.types.trees.BreadthFirstSorter;
import com.google.security.zynamics.zylib.types.trees.DepthFirstSorter;
import com.google.security.zynamics.zylib.types.trees.ITreeNode;
import com.google.security.zynamics.zylib.types.trees.Tree;
import com.google.security.zynamics.zylib.types.trees.TreeNode;
import java.util.List;

public final class CTagManager
implements IDatabaseObject,
ITagManager {
    private final Tree<CTag> m_tagTree;
    private final TagType m_type;
    private final SQLProvider m_provider;
    private final ListenerProvider<ITagManagerListener> m_listeners = new ListenerProvider();

    public CTagManager(Tree<CTag> tagTree, TagType type, SQLProvider provider) {
        this.m_tagTree = Preconditions.checkNotNull(tagTree, "IE00853: Tag tree argument can't be null");
        this.m_type = Preconditions.checkNotNull(type, "IE00854: Type argument can't be null");
        this.m_provider = Preconditions.checkNotNull(provider, "IE00855: Provider argument can't be null");
    }

    private static void link(ITreeNode<CTag> parent, ITreeNode<CTag> child) {
        child.setParent(parent);
        parent.addChild(child);
    }

    private static void unlink(ITreeNode<CTag> parent, ITreeNode<CTag> child) {
        child.setParent(null);
        parent.removeChild(child);
    }

    private boolean hasTag(ITreeNode<CTag> tag) {
        return tag == this.getRootTag() || BreadthFirstSorter.getSortedList(this.getRootTag()).contains(tag);
    }

    private void validateTag(ITreeNode<CTag> tag) {
        Preconditions.checkNotNull(tag, "IE00859: Tag argument can't be null");
        Preconditions.checkNotNull(tag.getObject(), "IE00860: Tag object can't be null");
        Preconditions.checkArgument(tag.getObject().getType() == this.m_type, "IE00861: Tag has an incorrect type");
        Preconditions.checkArgument(this.hasTag(tag), "IE00862: Tag is not managed by this manager");
    }

    @Override
    public void addListener(ITagManagerListener listener) {
        this.m_listeners.addListener(listener);
    }

    @Override
    public ITreeNode<CTag> addTag(ITreeNode<CTag> parent, String name) throws CouldntSaveDataException {
        this.validateTag(parent);
        Preconditions.checkNotNull(name, "IE00863: Name argument can't be null");
        CTag tag = this.m_provider.createTag(parent.getObject(), name, "", this.m_type);
        TreeNode<CTag> child = new TreeNode<CTag>(tag);
        CTagManager.link(parent, child);
        for (ITagManagerListener listener : this.m_listeners) {
            try {
                listener.addedTag(this, child);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        return child;
    }

    @Override
    public void deleteTag(ITreeNode<CTag> tag) throws CouldntDeleteException {
        this.validateTag(tag);
        Preconditions.checkArgument(tag != this.getRootTag(), "IE00864: Can not delete the root tag");
        this.m_provider.deleteTag(tag);
        ITreeNode<CTag> parent = tag.getParent();
        for (ITreeNode<CTag> child : tag.getChildren()) {
            CTagManager.link(parent, child);
        }
        parent.removeChild(tag);
        tag.setParent(null);
        tag.getObject().deleteTag();
        for (ITagManagerListener listener : this.m_listeners) {
            try {
                listener.deletedTag(this, parent, tag);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    @Override
    public void deleteTagSubTree(ITreeNode<CTag> tag) throws CouldntDeleteException {
        this.validateTag(tag);
        Preconditions.checkArgument(tag != this.getRootTag(), "IE00865: Can not delete the root tag");
        List<ITreeNode<CTag>> children = tag.getChildren();
        if (children.isEmpty()) {
            this.deleteTag(tag);
            return;
        }
        this.m_provider.deleteTagSubtree(tag);
        for (ITreeNode<CTag> child : children) {
            for (ITreeNode<CTag> c2 : DepthFirstSorter.getSortedList(child)) {
                c2.getParent().removeChild(c2);
                c2.getObject().deleteTag();
            }
            child.getParent().removeChild(child);
            child.getObject().deleteTag();
        }
        tag.getParent().removeChild(tag);
        tag.getObject().deleteTag();
        for (ITagManagerListener listener : this.m_listeners) {
            try {
                listener.deletedTagSubtree(this, tag.getParent(), tag);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    @Override
    public ITreeNode<CTag> getRootTag() {
        return this.m_tagTree.getRootNode();
    }

    @Override
    public boolean inSameDatabase(IDatabaseObject provider) {
        return provider.inSameDatabase(this.m_provider);
    }

    @Override
    public boolean inSameDatabase(SQLProvider provider) {
        return provider.equals(this.m_provider);
    }

    @Override
    public ITreeNode<CTag> insertTag(ITreeNode<CTag> parent, String name) throws CouldntSaveDataException {
        this.validateTag(parent);
        Preconditions.checkNotNull(name, "IE00867: Name argument can't be null");
        CTag tag = this.m_provider.insertTag(parent, name, "", this.m_type);
        List<ITreeNode<CTag>> children = parent.getChildren();
        TreeNode<CTag> tagTreeNode = new TreeNode<CTag>(tag);
        CTagManager.link(parent, tagTreeNode);
        for (ITreeNode<CTag> child : children) {
            parent.removeChild(child);
            CTagManager.link(tagTreeNode, child);
        }
        for (ITagManagerListener listener : this.m_listeners) {
            try {
                listener.insertedTag(this, parent, tagTreeNode);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        return tagTreeNode;
    }

    @Override
    public void moveTag(ITreeNode<CTag> parent, ITreeNode<CTag> child) throws CouldntSaveDataException {
        this.m_provider.moveTag(parent, child, this.m_type);
        ITreeNode<CTag> childParent = child.getParent();
        if (childParent != null) {
            for (ITreeNode iTreeNode : child.getChildren()) {
                CTagManager.unlink(child, iTreeNode);
                CTagManager.link(childParent, iTreeNode);
            }
            childParent.removeChild(child);
            for (ITagManagerListener iTagManagerListener : this.m_listeners) {
                try {
                    iTagManagerListener.deletedTag(this, parent, child);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }
        CTagManager.link(parent, child);
        for (ITagManagerListener iTagManagerListener : this.m_listeners) {
            try {
                iTagManagerListener.addedTag(this, child);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    @Override
    public void removeListener(ITagManagerListener listener) {
        this.m_listeners.removeListener(listener);
    }
}

