/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Tagging;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Tagging.ITagListener;
import com.google.security.zynamics.binnavi.Tagging.TagType;
import com.google.security.zynamics.binnavi.disassembly.IDatabaseObject;
import com.google.security.zynamics.zylib.general.ListenerProvider;

public final class CTag
implements IDatabaseObject {
    private final int m_id;
    private String m_name;
    private String m_description;
    private final TagType m_type;
    private final SQLProvider m_sql;
    private final ListenerProvider<ITagListener> m_listeners = new ListenerProvider();

    public CTag(int tagId, String name, String description, TagType type, SQLProvider sqlProvider) {
        Preconditions.checkArgument(tagId >= 0, "IE00845: Tag IDs must not be negative");
        this.m_name = Preconditions.checkNotNull(name, "IE00846: Name argument can't be null");
        this.m_description = Preconditions.checkNotNull(description, "IE00847: Description argument can't be null");
        this.m_type = Preconditions.checkNotNull(type, "IE00848: Type argument can't be null");
        this.m_sql = Preconditions.checkNotNull(sqlProvider, "IE00849: SQL Provider argument can't be null");
        this.m_id = tagId;
    }

    public void addListener(ITagListener listener) {
        this.m_listeners.addListener(listener);
    }

    public void deleteTag() {
        for (ITagListener listener : this.m_listeners) {
            try {
                listener.deletedTag(this);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public boolean equals(Object rhs) {
        if (!(rhs instanceof CTag)) {
            return false;
        }
        return this.m_id == ((CTag)rhs).m_id;
    }

    public String getDescription() {
        return this.m_description;
    }

    public int getId() {
        return this.m_id;
    }

    public String getName() {
        return this.m_name;
    }

    public TagType getType() {
        return this.m_type;
    }

    public int hashCode() {
        return this.m_id;
    }

    @Override
    public boolean inSameDatabase(IDatabaseObject object) {
        Preconditions.checkNotNull(object, "IE00850: Object argument can't be null");
        return object.inSameDatabase(this.m_sql);
    }

    @Override
    public boolean inSameDatabase(SQLProvider provider) {
        return this.m_sql == provider;
    }

    public void removeListener(ITagListener listener) {
        this.m_listeners.removeListener(listener);
    }

    public void setDescription(String description) throws CouldntSaveDataException {
        Preconditions.checkNotNull(description, "IE00851: Description argument can't be null");
        if (description.equals(this.m_description)) {
            return;
        }
        this.m_sql.setDescription(this, description);
        this.m_description = description;
        for (ITagListener listener : this.m_listeners) {
            try {
                listener.changedDescription(this, description);
            }
            catch (Exception e2) {
                CUtilityFunctions.logException(e2);
            }
        }
    }

    public void setName(String name) throws CouldntSaveDataException {
        Preconditions.checkNotNull(name, "IE00852: Name argument can't be null");
        if (name.equals(this.m_name)) {
            return;
        }
        this.m_sql.setName(this, name);
        this.m_name = name;
        for (ITagListener listener : this.m_listeners) {
            try {
                listener.changedName(this, name);
            }
            catch (Exception e2) {
                CUtilityFunctions.logException(e2);
            }
        }
    }

    public String toString() {
        return String.format("Tag '%s'", this.getName());
    }
}

