/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Startup;

import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.common.config.ConfigHelper;
import java.io.File;

public final class CSettingsDirectoryCreator {
    private CSettingsDirectoryCreator() {
    }

    private static boolean createNaviDirectory() {
        File dir = new File(ConfigHelper.getConfigurationDirectory("zynamics", "BinNavi"));
        return dir.exists() || dir.mkdir();
    }

    private static boolean createZynamicsDirectory() {
        File dir = new File(ConfigHelper.getZynamicsDirectory("zynamics"));
        return dir.exists() || dir.mkdir();
    }

    private static void showDirectoryCreationError(String directory) {
        String message2 = "E00001: Could not create the settings directory";
        String description = CUtilityFunctions.createDescription(String.format("BinNavi could not create the settings directory '%s'.", directory), new String[]{"Your user account does not have sufficient rights to create this directory"}, new String[]{"Changes to the global settings will not be saved", "The error log file can not be stored"});
        NaviErrorDialog.show(null, "E00001: Could not create the settings directory", description);
    }

    public static void createSettingsDirectory() {
        if (CSettingsDirectoryCreator.createZynamicsDirectory()) {
            if (!CSettingsDirectoryCreator.createNaviDirectory()) {
                CSettingsDirectoryCreator.showDirectoryCreationError(ConfigHelper.getConfigurationDirectory("zynamics", "BinNavi"));
            }
        } else {
            CSettingsDirectoryCreator.showDirectoryCreationError(ConfigHelper.getZynamicsDirectory("zynamics"));
        }
    }
}

