/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.REIL;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.config.ConfigManager;
import com.google.security.zynamics.binnavi.disassembly.CCodeNode;
import com.google.security.zynamics.binnavi.disassembly.CNaviViewEdge;
import com.google.security.zynamics.binnavi.disassembly.COperandTree;
import com.google.security.zynamics.binnavi.disassembly.COperandTreeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.views.CView;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.Builders.EdgeInitializer;
import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.OperandType;
import com.google.security.zynamics.reil.ReilBlock;
import com.google.security.zynamics.reil.ReilEdge;
import com.google.security.zynamics.reil.ReilGraph;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.ReilOperand;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.ReilGraphGenerator;
import com.google.security.zynamics.zylib.disassembly.ExpressionType;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.Convert;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class CReilViewCreator {
    private CReilViewCreator() {
    }

    private static COperandTree convert(INaviModule module, ReilOperand operand) {
        COperandTreeNode rootNode = module.createOperandExpression(CReilViewCreator.toDatabaseString(operand.getSize()), ExpressionType.SIZE_PREFIX);
        COperandTreeNode childNode = module.createOperandExpression(operand.getValue(), CReilViewCreator.getType(operand));
        COperandTreeNode.link(rootNode, childNode);
        return module.createOperand(rootNode);
    }

    private static COperandTree getEmptyOperand(INaviModule module) {
        COperandTreeNode rootNode = module.createOperandExpression("b4", ExpressionType.SIZE_PREFIX);
        COperandTreeNode childNode = module.createOperandExpression(" ", ExpressionType.SYMBOL);
        COperandTreeNode.link(rootNode, childNode);
        return module.createOperand(rootNode);
    }

    private static ExpressionType getType(ReilOperand operand) {
        if (Convert.isDecString(operand.getValue())) {
            return ExpressionType.IMMEDIATE_INTEGER;
        }
        return ExpressionType.REGISTER;
    }

    private static String toDatabaseString(OperandSize size) {
        switch (size) {
            case BYTE: {
                return "b1";
            }
            case WORD: {
                return "b2";
            }
            case DWORD: {
                return "b4";
            }
            case QWORD: {
                return "b8";
            }
            case OWORD: {
                return "b16";
            }
            case ADDRESS: {
                return "b4";
            }
        }
        throw new IllegalArgumentException(String.format("Error: Unknown operand size %s", new Object[]{size}));
    }

    public static INaviView create(INaviModule container, INaviView view) throws InternalTranslationException, CouldntLoadDataException {
        Preconditions.checkNotNull(container, "IE01768: Container argument can not be null");
        Preconditions.checkNotNull(view, "IE01769: View argument can not be null");
        HashMap<IAddress, String> textMap = new HashMap<IAddress, String>();
        for (CCodeNode node : view.getBasicBlocks()) {
            for (INaviInstruction instruction : node.getInstructions()) {
                textMap.put(instruction.getAddress(), instruction.toString());
            }
        }
        INaviView reilView = CReilViewCreator.create(container, view.getContent().getReilCode().getGraph());
        for (CCodeNode node : reilView.getBasicBlocks()) {
            for (INaviInstruction reilInstruction : node.getInstructions()) {
                if ((reilInstruction.getAddress().toLong() & 0xFFL) != 0L) continue;
                try {
                    node.getComments().appendLocalInstructionComment(reilInstruction, (String)textMap.get(ReilHelpers.toNativeAddress(reilInstruction.getAddress())));
                }
                catch (CouldntSaveDataException e2) {
                    CUtilityFunctions.logException(e2);
                }
            }
        }
        return reilView;
    }

    public static INaviView create(INaviModule container, List<ReilInstruction> instructions) {
        Preconditions.checkNotNull(container, "IE01775: Container argument can not be null");
        Preconditions.checkNotNull(instructions, "IE01779: Instructions argument can not be null");
        ArrayList<List<ReilInstruction>> instructionList = new ArrayList<List<ReilInstruction>>();
        instructionList.add(instructions);
        return CReilViewCreator.create(container, ReilGraphGenerator.createGraph(instructionList, new ArrayList<IAddress>()));
    }

    public static INaviView create(INaviModule container, ReilGraph graph) {
        Preconditions.checkNotNull(container, "IE01809: Container argument can not be null");
        Preconditions.checkNotNull(graph, "IE01815: Graph argument can not be null");
        CView view = container.getContent().getViewContainer().createView("REIL View", "");
        HashMap<ReilBlock, CCodeNode> nodeMap = new HashMap<ReilBlock, CCodeNode>();
        for (ReilBlock block : graph) {
            ArrayList<INaviInstruction> instructions = new ArrayList<INaviInstruction>();
            for (ReilInstruction reilInstruction : block) {
                ArrayList<COperandTree> operands = new ArrayList<COperandTree>();
                if (reilInstruction.getFirstOperand().getType() == OperandType.EMPTY) {
                    operands.add(CReilViewCreator.getEmptyOperand(container));
                } else {
                    operands.add(CReilViewCreator.convert(container, reilInstruction.getFirstOperand()));
                }
                if (reilInstruction.getSecondOperand().getType() == OperandType.EMPTY) {
                    operands.add(CReilViewCreator.getEmptyOperand(container));
                } else {
                    operands.add(CReilViewCreator.convert(container, reilInstruction.getSecondOperand()));
                }
                if (reilInstruction.getThirdOperand().getType() == OperandType.EMPTY) {
                    operands.add(CReilViewCreator.getEmptyOperand(container));
                } else {
                    operands.add(CReilViewCreator.convert(container, reilInstruction.getThirdOperand()));
                }
                INaviInstruction convertedInstruction = container.createInstruction(reilInstruction.getAddress(), reilInstruction.getMnemonic(), operands, new byte[0], "REIL");
                instructions.add(convertedInstruction);
            }
            CCodeNode node = view.getContent().createCodeNode(null, instructions);
            node.setColor(ConfigManager.instance().getColorSettings().getBasicBlocksColor());
            nodeMap.put(block, node);
        }
        for (ReilEdge edge : graph.getEdges()) {
            CNaviViewEdge reilEdge = view.getContent().createEdge((INaviViewNode)nodeMap.get(edge.getSource()), (INaviViewNode)nodeMap.get(edge.getTarget()), edge.getType());
            EdgeInitializer.adjustColor(reilEdge);
        }
        return view;
    }
}

