/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Plugins;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.security.zynamics.binnavi.Plugins.DisabledPluginReason;
import com.google.security.zynamics.binnavi.Plugins.IPluginRegistry;
import com.google.security.zynamics.binnavi.api2.IPluginInterface;
import com.google.security.zynamics.binnavi.api2.plugins.IPlugin;
import com.google.security.zynamics.binnavi.config.ConfigManager;
import com.google.security.zynamics.binnavi.config.PluginConfigItem;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class PluginRegistry
implements IPluginRegistry<IPlugin<IPluginInterface>> {
    private final List<IPlugin<IPluginInterface>> plugins = Lists.newArrayList();
    private final List<Pair<IPlugin<IPluginInterface>, DisabledPluginReason>> disabledPlugins = Lists.newArrayList();

    private void verifyPluginToAdd(IPlugin<IPluginInterface> plugin) {
        Preconditions.checkNotNull(plugin, "IE00835: Plugin can't be null");
        if (plugin.getName() == null || plugin.getName().equals("")) {
            throw new IllegalArgumentException("IE00836: Invalid plugin name");
        }
        if (plugin.getGuid() == 0L) {
            throw new IllegalArgumentException("IE00837: Invalid plugin GUID");
        }
        for (IPlugin<IPluginInterface> oldPlugin : this.plugins) {
            if (oldPlugin == plugin) {
                throw new IllegalArgumentException("IE00838: Can not add plugin more than once");
            }
            if (oldPlugin.getGuid() != plugin.getGuid()) continue;
            long l2 = plugin.getGuid();
            throw new IllegalArgumentException(new StringBuilder(61).append("IE00839: Plugin with GUID ").append(l2).append(" already exists").toString());
        }
    }

    @Override
    public void addDisabledPlugin(IPlugin<IPluginInterface> plugin, DisabledPluginReason reason) {
        Preconditions.checkNotNull(plugin, "IE00833: Plugin can't be null");
        Preconditions.checkNotNull(reason, "IE00834: Reason can't be null");
        this.disabledPlugins.add(new Pair<IPlugin<IPluginInterface>, DisabledPluginReason>(plugin, reason));
    }

    @Override
    public void addPlugin(IPlugin<IPluginInterface> plugin) {
        this.verifyPluginToAdd(plugin);
        for (PluginConfigItem pluginType : ConfigManager.instance().getGeneralSettings().getPlugins()) {
            if (pluginType.getGUID() != plugin.getGuid() || pluginType.isLoad()) continue;
            this.addDisabledPlugin(plugin, DisabledPluginReason.NotLoaded);
            return;
        }
        this.plugins.add(plugin);
    }

    @Override
    public List<Pair<IPlugin<IPluginInterface>, DisabledPluginReason>> getDisabledPlugins() {
        return new ArrayList<Pair<IPlugin<IPluginInterface>, DisabledPluginReason>>(this.disabledPlugins);
    }

    @Override
    public List<IPlugin<IPluginInterface>> getPlugins() {
        return new ArrayList<IPlugin<IPluginInterface>>(this.plugins);
    }

    @Override
    public Iterator<IPlugin<IPluginInterface>> iterator() {
        return this.plugins.iterator();
    }

    @Override
    public void removePlugin(IPlugin<IPluginInterface> plugin, DisabledPluginReason reason) {
        Preconditions.checkNotNull(plugin, "IE00840: Plugin can't be null");
        Preconditions.checkNotNull(reason, "IE00841: Reason can't be null");
        if (!this.plugins.remove(plugin)) {
            throw new IllegalArgumentException("IE00842: Plugin is not managed by the registry");
        }
        this.disabledPlugins.add(new Pair<IPlugin<IPluginInterface>, DisabledPluginReason>(plugin, reason));
    }

    @Override
    public void unloadAll() {
        for (IPlugin<IPluginInterface> plugin : Lists.newArrayList(this.plugins)) {
            plugin.unload();
            this.removePlugin(plugin, DisabledPluginReason.Unload);
        }
        this.disabledPlugins.clear();
    }
}

