/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Plugins;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Plugins.ClassPluginLoader;
import com.google.security.zynamics.binnavi.Plugins.JarPluginLoader;
import com.google.security.zynamics.binnavi.Plugins.LoadResult;
import com.google.security.zynamics.binnavi.Plugins.PluginStatus;
import com.google.security.zynamics.binnavi.api2.plugins.IPlugin;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.IStandardDescriptionUpdater;
import com.google.security.zynamics.zylib.io.DirUtils;
import com.google.security.zynamics.zylib.io.IDirectoryTraversalCallback;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public final class PluginLoader {
    private PluginLoader() {
    }

    private static <T> LoadResult<T> loadPluginFiles(String pluginPath, Set<File> pluginFiles, IStandardDescriptionUpdater descriptionUpdater) {
        ArrayList loadedPlugins = new ArrayList();
        ArrayList<Pair<String, Throwable>> failedPlugins = new ArrayList<Pair<String, Throwable>>();
        for (File pluginFile : pluginFiles) {
            if (pluginFile.getName().endsWith(".jar")) {
                descriptionUpdater.next();
                descriptionUpdater.setDescription(String.format("Loading plugin JAR file '%s'", pluginFile.getName()));
                JarPluginLoader.processJarFile(pluginFile, loadedPlugins, failedPlugins);
                continue;
            }
            if (!pluginFile.getName().endsWith(".class")) continue;
            descriptionUpdater.next();
            descriptionUpdater.setDescription(String.format("Loading plugin CLASS file '%s'", pluginFile.getName()));
            ClassPluginLoader.processClassFile(pluginPath, pluginFile, loadedPlugins, failedPlugins);
        }
        return new LoadResult(loadedPlugins, failedPlugins);
    }

    private static <T> LoadResult<T> validateLoadedPlugins(LoadResult<T> result) {
        HashSet<Long> guids = new HashSet<Long>();
        ArrayList validatedPlugins = new ArrayList();
        for (Pair<IPlugin<T>, PluginStatus> pluginPair : result.getLoadedPlugins()) {
            IPlugin<T> plugin = pluginPair.first();
            String name = plugin.getName();
            long guid = plugin.getGuid();
            if (name == null && guid == 0L) {
                validatedPlugins.add(new Pair<IPlugin<T>, PluginStatus>(plugin, PluginStatus.InvalidNameGuid));
            } else if (name == null) {
                validatedPlugins.add(new Pair<IPlugin<T>, PluginStatus>(plugin, PluginStatus.InvalidName));
            } else if (guid == 0L) {
                validatedPlugins.add(new Pair<IPlugin<T>, PluginStatus>(plugin, PluginStatus.InvalidGuid));
            } else if (guids.contains(guid)) {
                validatedPlugins.add(new Pair<IPlugin<T>, PluginStatus>(plugin, PluginStatus.DuplicateGuid));
            } else {
                validatedPlugins.add(new Pair<IPlugin<T>, PluginStatus>(plugin, PluginStatus.Valid));
            }
            guids.add(guid);
        }
        return new LoadResult(validatedPlugins, result.getFailedPlugins());
    }

    public static Set<File> collectPluginFiles(String directory) {
        final HashSet<File> pluginFiles = new HashSet<File>();
        File file = new File(directory);
        DirUtils.traverse(file, new IDirectoryTraversalCallback(){

            @Override
            public void entering(File directory) {
                System.out.println(directory.getName());
            }

            @Override
            public void leaving(File directory) {
            }

            @Override
            public void nextFile(File pluginFile) {
                System.out.println(pluginFile.getName());
                if (pluginFile.getName().endsWith(".jar") || pluginFile.getName().endsWith(".class")) {
                    pluginFiles.add(pluginFile);
                }
            }
        });
        return pluginFiles;
    }

    public static <T> LoadResult<T> loadPlugins(String pluginPath, Set<File> pluginFiles, IStandardDescriptionUpdater descriptionUpdater) {
        Preconditions.checkNotNull(pluginFiles, "IE00832: Plugin files can't be null");
        descriptionUpdater.reset();
        descriptionUpdater.setMaximum(pluginFiles.size());
        LoadResult<T> loadResult = PluginLoader.loadPluginFiles(pluginPath, pluginFiles, descriptionUpdater);
        return PluginLoader.validateLoadedPlugins(loadResult);
    }
}

