/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Plugins;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Plugins.DisabledPluginReason;
import com.google.security.zynamics.binnavi.Plugins.IPluginRegistry;
import com.google.security.zynamics.binnavi.Plugins.PluginStatus;
import com.google.security.zynamics.binnavi.api2.plugins.IPlugin;
import com.google.security.zynamics.binnavi.config.ConfigManager;
import com.google.security.zynamics.binnavi.config.PluginConfigItem;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class PluginInitializer {
    private PluginInitializer() {
    }

    private static <T> IPlugin<T> findPlugin(List<Pair<IPlugin<T>, PluginStatus>> validatedPlugins, long guid) {
        for (Pair<IPlugin<T>, PluginStatus> pt : validatedPlugins) {
            if (pt.first().getGuid() != guid) continue;
            return pt.first();
        }
        return null;
    }

    private static <T> void initializeKnownPlugins(T pluginInterface, IPluginRegistry<IPlugin<T>> registry, List<PluginConfigItem> xmlPluginOrder, List<Pair<IPlugin<T>, PluginStatus>> validatedPlugins, List<Pair<IPlugin<T>, Exception>> initializedPlugins, Set<Long> processedPlugins) {
        for (PluginConfigItem pt : xmlPluginOrder) {
            processedPlugins.add(pt.getGUID());
            IPlugin<T> plugin = PluginInitializer.findPlugin(validatedPlugins, pt.getGUID());
            if (plugin == null) continue;
            if (pt.isLoad()) {
                PluginInitializer.initializePlugin(plugin, pluginInterface, registry, initializedPlugins);
                continue;
            }
            registry.addDisabledPlugin(plugin, DisabledPluginReason.NotLoaded);
        }
    }

    private static <T> void initializePlugin(IPlugin<T> plugin, T pluginInterface, IPluginRegistry<IPlugin<T>> registry, List<Pair<IPlugin<T>, Exception>> initializedPlugins) {
        registry.addPlugin(plugin);
        try {
            plugin.init(pluginInterface);
        }
        catch (Exception exception) {
            registry.removePlugin(plugin, DisabledPluginReason.ThrewOnInit);
            initializedPlugins.add(new Pair<IPlugin<T>, Exception>(plugin, exception));
        }
    }

    private static <T> void initializeUnknownPlugins(IPluginRegistry<IPlugin<T>> registry, T pluginInterface, List<Pair<IPlugin<T>, PluginStatus>> validatedPlugins, List<Pair<IPlugin<T>, Exception>> initializedPlugins, Set<Long> processedPlugins) {
        for (Pair<IPlugin<T>, PluginStatus> pluginPair : validatedPlugins) {
            if (pluginPair.second() != PluginStatus.Valid || processedPlugins.contains(pluginPair.first().getGuid())) continue;
            PluginInitializer.initializePlugin(pluginPair.first(), pluginInterface, registry, initializedPlugins);
        }
    }

    public static <T> List<Pair<IPlugin<T>, Exception>> initializePlugins(T pluginInterface, IPluginRegistry<IPlugin<T>> registry, List<Pair<IPlugin<T>, PluginStatus>> list, ConfigManager configFile) {
        Preconditions.checkNotNull(pluginInterface, "IE00828: Plugin interface can't be null");
        Preconditions.checkNotNull(registry, "IE00829: Plugin registry can't be null");
        Preconditions.checkNotNull(list, "IE00830: Plugins can't be null");
        Preconditions.checkNotNull(configFile, "IE00831: Config File can't be null");
        ArrayList<Pair<IPlugin<T>, Exception>> initializedPlugins = new ArrayList<Pair<IPlugin<T>, Exception>>();
        List<PluginConfigItem> pluginOrder = configFile.getGeneralSettings().getPlugins();
        HashSet<Long> processedPlugins = new HashSet<Long>();
        PluginInitializer.initializeKnownPlugins(pluginInterface, registry, pluginOrder, list, initializedPlugins, processedPlugins);
        PluginInitializer.initializeUnknownPlugins(registry, pluginInterface, list, initializedPlugins, processedPlugins);
        return initializedPlugins;
    }
}

