/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Plugins;

import com.google.security.zynamics.binnavi.API.plugins.IPluginServer;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.Plugins.PluginStatus;
import com.google.security.zynamics.binnavi.api2.plugins.IPlugin;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.plugins.ClassPathHacker;
import com.google.security.zynamics.zylib.plugins.JarClassLoader;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.jar.Attributes;

public final class JarPluginLoader {
    private JarPluginLoader() {
    }

    private static String getMainClassName(File file) throws IOException {
        String string2 = String.valueOf(file.toURI().toURL());
        URL jarUrl = new URL("jar", "", new StringBuilder(2 + String.valueOf(string2).length()).append(string2).append("!/").toString());
        JarURLConnection urlConnection = (JarURLConnection)jarUrl.openConnection();
        Attributes attr = urlConnection.getMainAttributes();
        return attr == null ? null : attr.getValue(Attributes.Name.MAIN_CLASS);
    }

    private static <T> Collection<IPlugin<T>> loadPluginJar(File pluginFile) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IOException {
        String string2 = String.valueOf(pluginFile.getAbsolutePath());
        NaviLogger.info(string2.length() != 0 ? "Loading plugins from ".concat(string2) : new String("Loading plugins from "), new Object[0]);
        JarClassLoader jarLoader = new JarClassLoader(pluginFile.getAbsolutePath());
        String mainClassName = JarPluginLoader.getMainClassName(pluginFile);
        String string3 = String.valueOf(mainClassName);
        NaviLogger.info(string3.length() != 0 ? "Determined main class as ".concat(string3) : new String("Determined main class as "), new Object[0]);
        if (mainClassName == null) {
            return new ArrayList<IPlugin<T>>();
        }
        Class<?> cls = jarLoader.loadClass(mainClassName, true);
        if (IPluginServer.class.isAssignableFrom(cls)) {
            ClassPathHacker.addFile(pluginFile);
            IPluginServer server = (IPluginServer)cls.newInstance();
            return server.getPlugins();
        }
        return new ArrayList<IPlugin<T>>();
    }

    public static <T> void processJarFile(File pluginFile, List<Pair<IPlugin<T>, PluginStatus>> loadedPlugins, List<Pair<String, Throwable>> failedPlugins) {
        try {
            Collection<IPlugin<T>> plugins = JarPluginLoader.loadPluginJar(pluginFile);
            if (plugins != null) {
                for (IPlugin<T> plugin : plugins) {
                    loadedPlugins.add(new Pair<IPlugin<T>, PluginStatus>(plugin, PluginStatus.Valid));
                }
            }
        }
        catch (Exception e2) {
            failedPlugins.add(new Pair<String, Exception>(pluginFile.getAbsolutePath(), e2));
        }
    }
}

