/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Plugins;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.IStandardDescriptionUpdater;
import com.google.security.zynamics.zylib.io.DirUtils;
import com.google.security.zynamics.zylib.io.FileUtils;
import com.google.security.zynamics.zylib.io.IDirectoryTraversalCallback;
import com.google.security.zynamics.zylib.plugins.ClassPathHacker;
import java.io.File;
import java.util.HashSet;
import java.util.Set;

public final class JarLoader {
    private static final String JAR_DIRECTORY = "jars";

    private JarLoader() {
    }

    public static Set<File> collectJars(String rootPath) {
        Preconditions.checkNotNull(rootPath, "IE00827: BinNavi root path can't be null");
        final HashSet<File> jarFiles = Sets.newHashSet();
        String string2 = String.valueOf(File.separator);
        String string3 = String.valueOf(JAR_DIRECTORY);
        File jarDirectory = new File(new StringBuilder(0 + String.valueOf(rootPath).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(rootPath).append(string2).append(string3).toString());
        DirUtils.traverse(jarDirectory, new IDirectoryTraversalCallback(){

            @Override
            public void entering(File directory) {
            }

            @Override
            public void leaving(File directory) {
            }

            @Override
            public void nextFile(File file) {
                if (!FileUtils.getFileExtension(file).equals("jar")) {
                    return;
                }
                jarFiles.add(file);
            }
        });
        return jarFiles;
    }

    public static void loadJars(Set<File> jarFiles, IStandardDescriptionUpdater descriptionUpdater) {
        Preconditions.checkNotNull(jarFiles, "IE00700: JAR files argument can not be null");
        Preconditions.checkNotNull(descriptionUpdater, "IE00701: Description updater argument can not be null");
        descriptionUpdater.reset();
        descriptionUpdater.setMaximum(jarFiles.size());
        for (File file : jarFiles) {
            descriptionUpdater.next();
            descriptionUpdater.setDescription(String.format("Loading JAR file %s", file.getName()));
            NaviLogger.info("Loading JAR file %s", file.getAbsolutePath());
            ClassPathHacker.addFile(file);
        }
    }
}

