/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Plugins;

import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.Plugins.PluginStatus;
import com.google.security.zynamics.binnavi.api2.plugins.IPlugin;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.io.FileUtils;
import com.google.security.zynamics.zylib.plugins.FileClassLoader;
import java.io.File;
import java.util.List;

public final class ClassPluginLoader {
    private ClassPluginLoader() {
    }

    private static <T> IPlugin<T> loadClassFile(File file, String pluginDirectory) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        NaviLogger.info("Loading class file %s", file.getAbsolutePath());
        String string2 = String.valueOf(file.getParentFile().getPath());
        String string3 = String.valueOf(System.getProperty("file.separator"));
        FileClassLoader loader = new FileClassLoader(string3.length() != 0 ? string2.concat(string3) : new String(string2));
        String relativePath = pluginDirectory.length() == file.getParentFile().getPath().length() ? "" : file.getParentFile().getPath().substring(pluginDirectory.length());
        String classPrefix = relativePath.replaceAll("[/\\\\]", ".");
        String string4 = String.valueOf("".equals(classPrefix) ? "" : String.valueOf(classPrefix).concat("."));
        String string5 = String.valueOf(FileUtils.getFileBasename(file));
        Class<?> cls = loader.loadClass(string5.length() != 0 ? string4.concat(string5) : new String(string4));
        if (IPlugin.class.isAssignableFrom(cls)) {
            return (IPlugin)cls.newInstance();
        }
        return null;
    }

    public static <T> void processClassFile(String directory, File pluginFile, List<Pair<IPlugin<T>, PluginStatus>> loadedPlugins, List<Pair<String, Throwable>> failedPlugins) {
        try {
            IPlugin<T> plugin = ClassPluginLoader.loadClassFile(pluginFile, directory);
            if (plugin == null) {
                return;
            }
            loadedPlugins.add(new Pair<IPlugin<T>, PluginStatus>(plugin, PluginStatus.Valid));
        }
        catch (Exception e2) {
            failedPlugins.add(new Pair<String, Exception>(pluginFile.getAbsolutePath(), e2));
        }
    }
}

