/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Log;

import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.common.config.ConfigHelper;
import com.google.security.zynamics.zylib.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class CActionLogger {
    private static final Map<Long, Integer> m_countMap = new LinkedHashMap<Long, Integer>();
    private static final File m_actionsLogFile = new File(String.valueOf(ConfigHelper.getConfigurationDirectory("zynamics", "BinNavi")).concat("actions.log"));

    private CActionLogger() {
    }

    private static void load(File actionsLogFile) throws IOException {
        List<String> lines = FileUtils.readTextfileLines(actionsLogFile);
        for (String line : lines) {
            String[] parts = line.split(":");
            if (parts.length != 2) continue;
            m_countMap.put(Long.valueOf(parts[0]), Integer.valueOf(parts[1]));
        }
    }

    private static String mapToText() {
        StringBuffer buffer = new StringBuffer();
        for (Map.Entry<Long, Integer> entry : m_countMap.entrySet()) {
            buffer.append(String.format("%d:%d%n", entry.getKey(), entry.getValue()));
        }
        return buffer.toString();
    }

    public static void load() {
        if (m_actionsLogFile.exists()) {
            try {
                CActionLogger.load(m_actionsLogFile);
            }
            catch (IOException e2) {
                CUtilityFunctions.logException(e2);
            }
        }
    }

    public static void log(long actionId) {
        if (!m_countMap.containsKey(actionId)) {
            m_countMap.put(actionId, 0);
        }
        m_countMap.put(actionId, m_countMap.get(actionId) + 1);
        try {
            FileUtils.writeTextFile(m_actionsLogFile, CActionLogger.mapToText());
        }
        catch (IOException e2) {
            CUtilityFunctions.logException(e2);
        }
    }
}

