/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Importers;

import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.Progress.CGlobalProgressManager;
import com.google.security.zynamics.binnavi.Gui.Progress.IProgressOperation;
import com.google.security.zynamics.binnavi.Importers.ConfigFileException;
import com.google.security.zynamics.binnavi.Importers.ExporterException;
import com.google.security.zynamics.binnavi.Importers.ImportFailedException;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.CProgressPanel;
import com.google.security.zynamics.zylib.system.IdaException;

public abstract class CBaseExporter {
    protected static void handleExitCode(int exitCode) throws ExporterException {
        if (exitCode != 0 && (exitCode & 0xFE) != 254) {
            if (exitCode == 1) {
                throw new ExporterException("Error: IDA could not open the input file (Return Code: 1)");
            }
            if (exitCode == 4) {
                throw new ExporterException("Error: Invalid IDB file (Return Code: 4)");
            }
            if (exitCode == 5) {
                throw new ExporterException("Error: IDA can not process archive files (Return Code: 5)");
            }
            if (exitCode == 16) {
                throw new ExporterException("Error: The exporter could not connect to the database");
            }
            if (exitCode == 17) {
                throw new ExporterException("Error: Can't import. The module already exists in the database");
            }
            if (exitCode == 18) {
                throw new ExporterException("Error: Can't import. Database contains tables from old versions of BinNavi.");
            }
            throw new ExporterException(new StringBuilder(49).append("Error: IDA terminated with error code ").append(exitCode).toString());
        }
    }

    protected abstract void importModuleInternal(String var1, String var2, IDatabase var3) throws ConfigFileException, ExporterException, IdaException;

    public void importIdbFile(String idaDirectory, String idbFile, IDatabase database) throws ImportFailedException {
        try {
            this.importModule(idbFile, idaDirectory, database);
        }
        catch (ConfigFileException configFileException) {
            String string2 = String.valueOf(configFileException);
            throw new ImportFailedException(new StringBuilder(73 + String.valueOf(string2).length()).append("Error: Could not create the IDA2SQL temp file.\nImporting project failed.\n").append(string2).toString());
        }
        catch (IdaException idaException) {
            String string3 = String.valueOf(idaException);
            throw new ImportFailedException(new StringBuilder(58 + String.valueOf(string3).length()).append("Error: Could not start IDA Pro.\nImporting project failed.\n").append(string3).toString());
        }
        catch (ExporterException exporterException) {
            String string4 = String.valueOf(exporterException);
            throw new ImportFailedException(new StringBuilder(33 + String.valueOf(string4).length()).append("Error: Importing project failed.\n").append(string4).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importModule(String idbFile, String idaDirecory, IDatabase database) throws ConfigFileException, IdaException, ExporterException {
        CIdaImporterOperation operation = new CIdaImporterOperation(idbFile);
        try {
            this.importModuleInternal(idbFile, idaDirecory, database);
        }
        finally {
            operation.stop();
        }
    }

    private static class CIdaImporterOperation
    implements IProgressOperation {
        private final CProgressPanel m_progressBar;

        public CIdaImporterOperation(String filename) {
            this.m_progressBar = new CProgressPanel(String.format("Importing IDB file '%s'", filename), true, false);
            this.m_progressBar.start();
            CGlobalProgressManager.instance().add(this);
        }

        @Override
        public String getDescription() {
            return "Importing IDB file";
        }

        @Override
        public CProgressPanel getProgressPanel() {
            return this.m_progressBar;
        }

        public void stop() {
            this.m_progressBar.stop();
            CGlobalProgressManager.instance().remove(this);
        }
    }
}

