/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.plugins;

import com.google.security.zynamics.binnavi.Gui.plugins.PluginItem;
import com.google.security.zynamics.binnavi.Plugins.DisabledPluginReason;
import com.google.security.zynamics.binnavi.Plugins.IPluginRegistry;
import com.google.security.zynamics.binnavi.api2.plugins.IPlugin;
import com.google.security.zynamics.binnavi.config.ConfigManager;
import com.google.security.zynamics.binnavi.config.PluginConfigItem;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.gui.JCheckedListbox;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;

public final class PluginListBox<T>
extends JCheckedListbox<PluginItem<T>> {
    private final DefaultListModel<PluginItem<T>> model = (DefaultListModel)this.getModel();

    public PluginListBox(IPluginRegistry<IPlugin<T>> registry, ConfigManager configFile) {
        super(PluginListBox.createPluginListModel(registry, configFile));
        this.checkLoadedPlugins(configFile);
    }

    private static <T> void addPluginIfLoaded(IPluginRegistry<IPlugin<T>> registry, DefaultListModel<PluginItem<T>> model, long guid, List<IPlugin<T>> added) {
        for (IPlugin iPlugin : registry) {
            if (guid != iPlugin.getGuid()) continue;
            model.addElement(new PluginItem(iPlugin));
            added.add(iPlugin);
        }
    }

    private static <T> void addPluginIfUnloaded(IPluginRegistry<IPlugin<T>> registry, DefaultListModel<PluginItem<T>> model, long guid, List<IPlugin<T>> added) {
        for (Pair<IPlugin<T>, DisabledPluginReason> pluginPair : registry.getDisabledPlugins()) {
            IPlugin<T> plugin = pluginPair.first();
            if (guid != plugin.getGuid()) continue;
            model.addElement(new PluginItem<T>(plugin));
            added.add(plugin);
        }
    }

    private static <T> void addUnmentionedPlugins(IPluginRegistry<IPlugin<T>> registry, DefaultListModel<PluginItem<T>> model, List<IPlugin<T>> added) {
        for (IPlugin iPlugin : registry) {
            boolean contains = false;
            for (IPlugin<T> plugin2 : added) {
                if (iPlugin != plugin2) continue;
                contains = true;
            }
            if (contains) continue;
            model.addElement(new PluginItem(iPlugin));
        }
    }

    private static <T> DefaultListModel<PluginItem<T>> createPluginListModel(IPluginRegistry<IPlugin<T>> registry, ConfigManager configFile) {
        DefaultListModel<PluginItem<T>> model = new DefaultListModel<PluginItem<T>>();
        ArrayList<IPlugin<T>> added = new ArrayList<IPlugin<T>>();
        for (PluginConfigItem plugin : configFile.getGeneralSettings().getPlugins()) {
            long guid = plugin.getGUID();
            PluginListBox.addPluginIfLoaded(registry, model, guid, added);
            PluginListBox.addPluginIfUnloaded(registry, model, guid, added);
        }
        PluginListBox.addUnmentionedPlugins(registry, model, added);
        return model;
    }

    private void checkLoadedPlugins(ConfigManager configFile) {
        int i2;
        ArrayList checked = new ArrayList();
        for (i2 = 0; i2 < this.model.getSize(); ++i2) {
            for (PluginConfigItem plugin : configFile.getGeneralSettings().getPlugins()) {
                if (plugin.getGUID() == ((IPlugin)this.model.get(i2).getObject()).getGuid()) {
                    this.setChecked(i2, plugin.isLoad());
                }
                checked.add(this.model.get(i2).getObject());
            }
        }
        for (i2 = configFile.getGeneralSettings().getPlugins().size(); i2 < this.model.getSize(); ++i2) {
            this.setChecked(i2, true);
        }
    }

    public void switchElements(int first, int second) {
        boolean oldFirst = this.isChecked(first);
        this.setChecked(first, this.isChecked(second));
        this.setChecked(second, oldFirst);
        PluginItem<T> oldFirstObject = this.model.getElementAt(first);
        this.model.remove(first);
        this.model.insertElementAt(oldFirstObject, second);
        this.setSelectedIndex(second);
    }
}

