/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.plugins;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CMain;
import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.plugins.PluginItem;
import com.google.security.zynamics.binnavi.Gui.plugins.PluginListBox;
import com.google.security.zynamics.binnavi.Plugins.IPluginRegistry;
import com.google.security.zynamics.binnavi.api2.plugins.IPlugin;
import com.google.security.zynamics.binnavi.config.ConfigManager;
import com.google.security.zynamics.binnavi.config.PluginConfigItem;
import com.google.security.zynamics.zylib.gui.CDialogEscaper;
import com.google.security.zynamics.zylib.gui.CPanelTwoButtons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public final class CPluginDialog<T>
extends JDialog {
    private final PluginListBox<T> pluginList;
    private final JTextArea pluginDescriptionTextArea;

    public CPluginDialog(JFrame parent, IPluginRegistry<IPlugin<T>> registry, ConfigManager configFile) {
        super(parent, "Plugins", true);
        Preconditions.checkNotNull(registry, "IE02058: Plugin Registry can't be null");
        Preconditions.checkNotNull(configFile, "IE02059: Config file can't be null");
        new CDialogEscaper(this);
        this.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel(new BorderLayout());
        JPanel sortPanel = new JPanel(new GridBagLayout());
        JButton upButton = new JButton(CActionProxy.proxy(new MoveUpAction()));
        JButton downButton = new JButton(CActionProxy.proxy(new MoveDownAction()));
        InternalListener listener = new InternalListener(configFile);
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = new Insets(3, 3, 3, 3);
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 0;
        gbConstraints.weighty = 1.0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridheight = 1;
        gbConstraints.gridwidth = 1;
        sortPanel.add((Component)upButton, gbConstraints);
        gbConstraints.gridy = 1;
        sortPanel.add((Component)downButton, gbConstraints);
        JPanel leftPanel = new JPanel(new GridBagLayout());
        JPanel rightPanel = new JPanel(new BorderLayout());
        this.pluginDescriptionTextArea = new JTextArea();
        this.pluginDescriptionTextArea.setEditable(false);
        this.pluginDescriptionTextArea.setLineWrap(true);
        this.pluginDescriptionTextArea.setWrapStyleWord(true);
        rightPanel.add((Component)new JScrollPane(this.pluginDescriptionTextArea), "Center");
        this.pluginList = new PluginListBox<T>(registry, configFile);
        this.pluginList.addListSelectionListener(listener);
        GridBagConstraints gbConstraints2 = new GridBagConstraints();
        gbConstraints2.insets = new Insets(3, 3, 3, 3);
        gbConstraints2.gridx = 0;
        gbConstraints2.gridy = 0;
        gbConstraints2.gridheight = 1;
        gbConstraints2.gridwidth = 1;
        gbConstraints2.anchor = 11;
        leftPanel.add((Component)sortPanel, gbConstraints2);
        gbConstraints2.weighty = 1.0;
        gbConstraints2.weightx = 1.0;
        gbConstraints2.insets = new Insets(3, 3, 3, 3);
        gbConstraints2.fill = 1;
        gbConstraints2.gridx = 1;
        gbConstraints2.gridy = 0;
        gbConstraints2.gridheight = 1;
        gbConstraints2.gridwidth = 2;
        leftPanel.add((Component)new JScrollPane(this.pluginList), gbConstraints2);
        JSplitPane splitPane = new JSplitPane(1, true, leftPanel, rightPanel);
        mainPanel.add(splitPane);
        GridBagConstraints gbConstraints3 = new GridBagConstraints();
        gbConstraints3.insets = new Insets(3, 3, 3, 3);
        gbConstraints3.gridx = 1;
        gbConstraints3.gridy = 0;
        gbConstraints3.ipadx = 400;
        gbConstraints3.ipady = 200;
        gbConstraints3.gridheight = 1;
        gbConstraints3.gridwidth = 1;
        gbConstraints3.anchor = 11;
        gbConstraints3.fill = 1;
        this.add((Component)mainPanel, "Center");
        CPanelTwoButtons panel = new CPanelTwoButtons(listener, "OK", "Cancel");
        this.getRootPane().setDefaultButton(panel.getFirstButton());
        this.add((Component)panel, "South");
        this.setSize(600, 400);
        this.setLocationRelativeTo(parent);
    }

    private class MoveUpAction
    extends AbstractAction {
        private static final long serialVersionUID = -8853973865690704629L;

        public MoveUpAction() {
            this.putValue("SmallIcon", new ImageIcon(CMain.class.getResource("data/arrow_up.png")));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int selected = CPluginDialog.this.pluginList.getSelectedIndex();
            if (selected == -1 || selected == 0) {
                return;
            }
            CPluginDialog.this.pluginList.switchElements(selected, selected - 1);
        }
    }

    private class MoveDownAction
    extends AbstractAction {
        private static final long serialVersionUID = 7778701107890773452L;

        public MoveDownAction() {
            this.putValue("SmallIcon", new ImageIcon(CMain.class.getResource("data/arrow_down.png")));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int selected = CPluginDialog.this.pluginList.getSelectedIndex();
            if (selected == -1 || selected == CPluginDialog.this.pluginList.getModel().getSize() - 1) {
                return;
            }
            CPluginDialog.this.pluginList.switchElements(selected, selected + 1);
        }
    }

    private class InternalListener<T>
    implements ListSelectionListener,
    ActionListener {
        private final ConfigManager configFile;

        public InternalListener(ConfigManager configFile) {
            this.configFile = configFile;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getActionCommand().equals("OK")) {
                this.configFile.getGeneralSettings().getPlugins().clear();
                DefaultListModel model = (DefaultListModel)CPluginDialog.this.pluginList.getModel();
                for (int i2 = 0; i2 < model.getSize(); ++i2) {
                    PluginItem pluginItem = (PluginItem)model.get(i2);
                    PluginConfigItem pluginType = new PluginConfigItem();
                    pluginType.setName(((IPlugin)pluginItem.getObject()).getName());
                    pluginType.setGUID(((IPlugin)pluginItem.getObject()).getGuid());
                    pluginType.setLoad(CPluginDialog.this.pluginList.isChecked(i2));
                    this.configFile.getGeneralSettings().getPlugins().add(pluginType);
                }
                CPluginDialog.this.setVisible(false);
                CPluginDialog.this.dispose();
            } else if (event.getActionCommand().equals("Cancel")) {
                CPluginDialog.this.setVisible(false);
                CPluginDialog.this.dispose();
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (!event.getValueIsAdjusting()) {
                PluginItem pluginItem = (PluginItem)CPluginDialog.this.pluginList.getSelectedValue();
                if (pluginItem == null) {
                    return;
                }
                CPluginDialog.this.pluginDescriptionTextArea.setText(((IPlugin)pluginItem.getObject()).getDescription());
            }
        }
    }
}

