/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Tutorials;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CMain;
import com.google.security.zynamics.binnavi.Gui.CIconInitializer;
import com.google.security.zynamics.binnavi.Tutorials.CTutorial;
import com.google.security.zynamics.binnavi.Tutorials.ITutorialListener;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public final class CTutorialDialog
extends JDialog {
    private static final long serialVersionUID = 5087316538644576623L;
    private static CTutorialDialog m_instance = new CTutorialDialog();
    private static final String WRONG_ACTION_STRING = "Wrong action executed (%d)";
    private static final String TOPIC_STRING = "Current Tutorial: %s (Step %d of %d)";
    private final JTextPane m_descriptionField = new JTextPane();
    private final InternalTutorialListener m_listener = new InternalTutorialListener();
    private CTutorial m_currentTutorial = null;
    private final JLabel m_topicLabel = new JLabel();
    private final JTextField m_warningLabel = new JTextField("XXXXXXXX");
    private final JButton m_nextButton = new JButton(new NextAction());
    private final JButton m_skipButton = new JButton(new SkipAction());

    private CTutorialDialog() {
        super((Window)null, "BinNavi Tutorial");
        CIconInitializer.initializeWindowIcons(this);
        this.setLayout(new BorderLayout());
        this.m_topicLabel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.m_descriptionField.setContentType("text/html");
        this.m_descriptionField.setEditable(false);
        this.m_descriptionField.setBorder(new TitledBorder(""));
        JPanel topPanel = new JPanel();
        topPanel.add(this.m_topicLabel);
        this.add((Component)this.m_topicLabel, "North");
        this.add(new JScrollPane(this.m_descriptionField));
        JPanel bottomPanel = new JPanel(new BorderLayout());
        JButton cancelButton = new JButton(new QuitAction());
        JPanel leftPanel = new JPanel(new BorderLayout());
        this.m_warningLabel.setEditable(false);
        this.m_warningLabel.setForeground(Color.RED);
        this.m_warningLabel.setBorder(new EmptyBorder(0, 5, 0, 0));
        leftPanel.add((Component)cancelButton, "West");
        leftPanel.add(this.m_warningLabel);
        JPanel buttonsPanel = new JPanel(new GridLayout(0, 2));
        buttonsPanel.add(this.m_skipButton);
        buttonsPanel.add(this.m_nextButton);
        bottomPanel.add((Component)leftPanel, "West");
        bottomPanel.add((Component)buttonsPanel, "East");
        this.add((Component)bottomPanel, "South");
        this.setSize(550, 300);
        GuiHelper.centerOnScreen(this);
        this.setLocation(this.getLocation().x + 200, this.getLocation().y - 200);
        this.setAlwaysOnTop(true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new InternalWindowListener());
    }

    public static CTutorialDialog instance() {
        return m_instance;
    }

    private void quit() {
        if (0 == CMessageBox.showYesNoCancelQuestion(this, "Do you really want to quit the current tutorial?")) {
            this.m_currentTutorial.removeListener(this.m_listener);
            this.m_currentTutorial = null;
            this.m_warningLabel.setText("");
            this.updateNextButton();
            this.m_skipButton.setEnabled(true);
            this.m_descriptionField.setText("");
            this.setVisible(false);
        }
    }

    private void updateNextButton() {
        this.m_nextButton.setEnabled(this.m_currentTutorial != null && this.m_currentTutorial.getStepCounter() != this.m_currentTutorial.getStepCount() && this.m_currentTutorial.getCurrentStep().canNext());
    }

    public CTutorial getCurrentTutorial() {
        return this.m_currentTutorial;
    }

    public void start(CTutorial tutorial) {
        Preconditions.checkNotNull(tutorial, "IE01296: Tutorial argument can not be null");
        tutorial.addListener(this.m_listener);
        tutorial.start();
    }

    public void wrongAction(long actionId) {
        this.m_warningLabel.setText(String.format(WRONG_ACTION_STRING, actionId));
        this.toFront();
    }

    private class SkipAction
    extends AbstractAction {
        private static final long serialVersionUID = -623733076208212254L;

        private SkipAction() {
            super("Skip Step", new ImageIcon(CMain.class.getResource("data/arrow_right.png")));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CTutorialDialog.this.m_currentTutorial.next();
        }
    }

    private class QuitAction
    extends AbstractAction {
        private static final long serialVersionUID = 5896923932054029970L;

        private QuitAction() {
            super("Quit", new ImageIcon(CMain.class.getResource("data/cancel.png")));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CTutorialDialog.this.quit();
        }
    }

    private class NextAction
    extends AbstractAction {
        private static final long serialVersionUID = 7665614446808231684L;

        private NextAction() {
            super("Next", new ImageIcon(CMain.class.getResource("data/arrow_right.png")));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CTutorialDialog.this.m_currentTutorial.next();
        }
    }

    private class InternalWindowListener
    extends WindowAdapter {
        private InternalWindowListener() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            CTutorialDialog.this.quit();
        }
    }

    private class InternalTutorialListener
    implements ITutorialListener {
        private InternalTutorialListener() {
        }

        @Override
        public void changedStep(CTutorial tutorial) {
            CTutorialDialog.this.m_warningLabel.setText("");
            CTutorialDialog.this.updateNextButton();
            CTutorialDialog.this.m_topicLabel.setText(String.format(CTutorialDialog.TOPIC_STRING, tutorial.getName(), tutorial.getStepCounter() + 1, tutorial.getStepCount()));
            CTutorialDialog.this.m_descriptionField.setText(tutorial.getCurrentStep().getDescription());
            CTutorialDialog.this.m_descriptionField.setCaretPosition(0);
            CTutorialDialog.this.toFront();
        }

        @Override
        public void finished(CTutorial tutorial) {
            CTutorialDialog.this.m_warningLabel.setText("");
            CTutorialDialog.this.updateNextButton();
            CTutorialDialog.this.m_skipButton.setEnabled(false);
            CTutorialDialog.this.m_descriptionField.setText("Tutorial finished");
            CTutorialDialog.this.toFront();
        }

        @Override
        public void started(CTutorial tutorial) {
            CTutorialDialog.this.m_warningLabel.setText("");
            CTutorialDialog.this.m_currentTutorial = tutorial;
            CTutorialDialog.this.m_topicLabel.setText(String.format(CTutorialDialog.TOPIC_STRING, tutorial.getName(), tutorial.getStepCounter() + 1, tutorial.getStepCount()));
            CTutorialDialog.this.updateNextButton();
            if (!CTutorialDialog.this.isVisible()) {
                CTutorialDialog.this.setVisible(true);
            }
            CTutorialDialog.this.m_descriptionField.setText(tutorial.getCurrentStep().getDescription());
            CTutorialDialog.this.toFront();
        }
    }
}

