/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.StandardEditPanel;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.CLabeledComponent;
import com.google.security.zynamics.binnavi.Gui.SaveFields.CSaveField;
import com.google.security.zynamics.binnavi.Gui.SaveFields.CSavePane;
import com.google.security.zynamics.binnavi.Gui.StandardEditPanel.IFieldDescription;
import com.google.security.zynamics.binnavi.Gui.StandardEditPanel.IInputPanelListener;
import com.google.security.zynamics.binnavi.Help.CHelpLabel;
import com.google.security.zynamics.binnavi.Help.CHelpSaveField;
import com.google.security.zynamics.binnavi.Help.CHelpSavePane;
import com.google.security.zynamics.zylib.date.DateHelpers;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.gui.textfields.JTextFieldLimit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public final class CStandardEditPanel
extends JPanel {
    private static final long serialVersionUID = 143124176789333548L;
    private final CSaveField m_nameTextField;
    private final JLabel m_creationDateValueLabel;
    private final JLabel m_modificationDateValueLabel;
    private final CSavePane m_descriptionField;
    private final ListenerProvider<IInputPanelListener> m_listeners = new ListenerProvider();
    private String m_savedName;
    private String m_savedDescription;

    public CStandardEditPanel(String headline, IFieldDescription<String> name, IFieldDescription<String> description, IFieldDescription<Date> creationDate, IFieldDescription<Date> modificationDate) {
        super(new BorderLayout(5, 5));
        Preconditions.checkNotNull(headline, "IE02072: Headline argument can not be null");
        Preconditions.checkNotNull(name, "IE02073: Name argument can not be null");
        Preconditions.checkNotNull(description, "IE02074: Description argument can not be null");
        Preconditions.checkNotNull(creationDate, "IE02075: Creation date argument can not be null");
        Preconditions.checkNotNull(modificationDate, "IE02076: Modification date argument can not be null");
        this.m_savedName = name.getValue();
        this.m_savedDescription = description.getValue();
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.m_nameTextField = new CHelpSaveField(name.getHelp());
        this.m_nameTextField.setDocument(new JTextFieldLimit());
        this.m_nameTextField.setText(name.getValue());
        this.m_creationDateValueLabel = new CHelpLabel(DateHelpers.formatDateTime(creationDate.getValue()), creationDate.getHelp());
        this.m_modificationDateValueLabel = new CHelpLabel(DateHelpers.formatDateTime(modificationDate.getValue()), modificationDate.getHelp());
        this.m_descriptionField = new CHelpSavePane(description.getHelp());
        this.m_descriptionField.setDocument(new JTextFieldLimit());
        this.m_descriptionField.setText(description.getValue());
        this.addNameDatesPanel(headline, name, creationDate, modificationDate);
        this.addDescriptionPanel();
        UpdateListener updateListener = new UpdateListener();
        this.m_nameTextField.getDocument().addDocumentListener(updateListener);
        this.m_descriptionField.getDocument().addDocumentListener(updateListener);
    }

    private void addDescriptionPanel() {
        JPanel descriptionPanel = new JPanel(new BorderLayout());
        descriptionPanel.setMinimumSize(new Dimension(descriptionPanel.getPreferredSize().width, 50));
        descriptionPanel.add(new JScrollPane(this.m_descriptionField));
        descriptionPanel.setBorder(new TitledBorder("Description:"));
        descriptionPanel.setMinimumSize(new Dimension(0, 146));
        descriptionPanel.setPreferredSize(new Dimension(0, 146));
        this.add((Component)descriptionPanel, "Center");
    }

    private void addNameDatesPanel(String headline, IFieldDescription<String> name, IFieldDescription<Date> creationDate, IFieldDescription<Date> modificationDate) {
        JPanel nameDatesPanel = new JPanel(new GridLayout(3, 1, 5, 5));
        nameDatesPanel.setBorder(new TitledBorder(headline));
        nameDatesPanel.add(new CLabeledComponent("Name:", name.getHelp(), this.m_nameTextField));
        nameDatesPanel.add(new CLabeledComponent("Creation Date:", creationDate.getHelp(), this.m_creationDateValueLabel));
        nameDatesPanel.add(new CLabeledComponent("Modification Date:", modificationDate.getHelp(), this.m_modificationDateValueLabel));
        this.add((Component)nameDatesPanel, "North");
    }

    private void notifyChangeListeners() {
        for (IInputPanelListener listener : this.m_listeners) {
            try {
                listener.changedInput();
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    private void updateSaveFields() {
        this.m_nameTextField.setModified(!this.m_savedName.equals(this.m_nameTextField.getText()));
        this.m_descriptionField.setModified(!this.m_savedDescription.equals(this.m_descriptionField.getText()));
    }

    public void addInputListener(IInputPanelListener listener) {
        this.m_listeners.addListener(listener);
    }

    public String getDescription() {
        return this.m_descriptionField.getText();
    }

    public String getNameString() {
        return this.m_nameTextField.getText();
    }

    public void setDescription(String description) {
        Preconditions.checkNotNull(description, "IE02077: Description argument can not be null");
        this.m_savedDescription = description;
        this.m_descriptionField.setText(description);
        this.updateSaveFields();
    }

    public void setModificationDate(Date date) {
        Preconditions.checkNotNull(date, "IE02078: Date argument can not be null");
        this.m_modificationDateValueLabel.setText(DateHelpers.formatDateTime(date));
    }

    public void setNameString(String name) {
        Preconditions.checkNotNull(name, "IE02079: Name argument can not be null");
        this.m_savedName = name;
        this.m_nameTextField.setText(name);
        this.updateSaveFields();
    }

    private class UpdateListener
    implements DocumentListener {
        private UpdateListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent event) {
            CStandardEditPanel.this.updateSaveFields();
            CStandardEditPanel.this.notifyChangeListeners();
        }

        @Override
        public void insertUpdate(DocumentEvent event) {
            CStandardEditPanel.this.updateSaveFields();
            CStandardEditPanel.this.notifyChangeListeners();
        }

        @Override
        public void removeUpdate(DocumentEvent event) {
            CStandardEditPanel.this.updateSaveFields();
            CStandardEditPanel.this.notifyChangeListeners();
        }
    }
}

