/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Scripting;

import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.IStandardDescriptionUpdater;
import com.google.security.zynamics.zylib.gui.scripting.ConsoleWriter;
import com.google.security.zynamics.zylib.gui.scripting.ScriptRunner;
import com.google.security.zynamics.zylib.io.DirUtils;
import com.google.security.zynamics.zylib.io.FileUtils;
import com.google.security.zynamics.zylib.io.IDirectoryTraversalCallback;
import java.io.File;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public final class ScriptLoader {
    private ScriptLoader() {
    }

    private static <T> void executeScript(File file, T pluginInterface) {
        ArrayList<Pair<String, Object>> bindings = new ArrayList<Pair<String, Object>>();
        ConsoleWriter consoleWriter = new ConsoleWriter(new StringWriter());
        bindings.add(new Pair<String, T>("navi", pluginInterface));
        bindings.add(new Pair<String, ConsoleWriter>("SCRIPT_CONSOLE", consoleWriter));
        try {
            ScriptRunner.runScript(file, bindings);
            if (consoleWriter.getOutput() != null) {
                NaviLogger.info(consoleWriter.getOutput(), new Object[0]);
            }
        }
        catch (Exception exception) {
            String message2 = "E00061: Script caused an error while loading";
            String description = CUtilityFunctions.createDescription(String.format("The script file '%s' could not be loaded because it caused an exception. You should check the stdout console to see errors in the script which were not passed to BinNavi.", file.getAbsoluteFile()), new String[]{"The script contains a bug that caused the exception"}, new String[]{"The script was not loaded and the functionality of the script will not be available in BinNavi"});
            NaviLogger.severe("E00061: Script caused an error while loading", new Object[0]);
            CUtilityFunctions.logException(exception);
            NaviLogger.severe(consoleWriter.getOutput(), new Object[0]);
            NaviErrorDialog.show(null, "E00061: Script caused an error while loading", description, exception);
        }
    }

    private static boolean isLibDirectory(File scriptDir, File directory) {
        if (directory.getParentFile().equals(scriptDir)) {
            String[] splitPath = directory.getAbsolutePath().split("\\".equals(File.separator) ? "\\\\" : File.separator);
            String lastPath = splitPath[splitPath.length - 1];
            return "lib".equals(lastPath);
        }
        return false;
    }

    public static Set<File> collectScripts(String startupPath) {
        final HashSet<File> scriptFiles = new HashSet<File>();
        String string2 = String.valueOf(File.separator);
        String scriptPath = new StringBuilder(7 + String.valueOf(startupPath).length() + String.valueOf(string2).length()).append(startupPath).append(string2).append("scripts").toString();
        final File scriptDir = new File(scriptPath);
        DirUtils.traverse(scriptDir, new IDirectoryTraversalCallback(){
            private boolean skip = false;

            @Override
            public void entering(File directory) {
                this.skip = ScriptLoader.isLibDirectory(scriptDir, directory);
            }

            @Override
            public void leaving(File directory) {
                this.skip = false;
            }

            @Override
            public void nextFile(File file) {
                if (this.skip) {
                    return;
                }
                String filename = FileUtils.getFileBasename(file);
                if ("init".equals(filename) || !ScriptRunner.canRun(file)) {
                    return;
                }
                scriptFiles.add(file);
            }
        });
        return scriptFiles;
    }

    public static <T> void init(Set<File> scriptFiles, T pluginInterface, IStandardDescriptionUpdater descriptionUpdater) {
        descriptionUpdater.reset();
        descriptionUpdater.setMaximum(scriptFiles.size());
        for (File file : scriptFiles) {
            String rawFilename = file.getName();
            descriptionUpdater.next();
            descriptionUpdater.setDescription(String.format("Loading script file '%s'", rawFilename));
            ScriptLoader.executeScript(file, pluginInterface);
        }
    }
}

