/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Scripting;

import com.google.security.zynamics.binnavi.API.plugins.PluginInterface;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Gui.CProgressDialog;
import com.google.security.zynamics.binnavi.Gui.LastDirFileChooser;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.CEndlessHelperThread;
import com.google.security.zynamics.zylib.gui.scripting.ConsoleWriter;
import com.google.security.zynamics.zylib.gui.scripting.IScriptPanel;
import com.google.security.zynamics.zylib.gui.scripting.ScriptRunner;
import com.google.security.zynamics.zylib.gui.scripting.ScriptingMenuBar;
import com.google.security.zynamics.zylib.gui.scripting.console.ConsolePane;
import com.google.security.zynamics.zylib.io.FileUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.swing.JDialog;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class CScriptingDialog
extends JDialog {
    private final JTabbedPane scriptTab = new JTabbedPane();
    private final MenuBar menuBar;
    private final Map<String, Object> m_bindings = new HashMap<String, Object>();
    private final String defaultLanguage;
    private final String scriptsDirectory;

    public CScriptingDialog(Frame owner, String defaultLanguage, PluginInterface pluginInterface) {
        this(owner, defaultLanguage, pluginInterface, new HashMap<String, Object>());
    }

    public CScriptingDialog(Frame owner, String defaultLanguage, PluginInterface pluginInterface, Map<String, Object> bindings) {
        super(owner, "Scripting", false);
        this.defaultLanguage = defaultLanguage;
        String string2 = PluginInterface.instance().getProgramPath();
        String string3 = String.valueOf(File.separator);
        this.scriptsDirectory = new StringBuilder(7 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append(string3).append("scripts").toString();
        this.addBinding("navi", pluginInterface);
        this.addBinding("dbs", pluginInterface.getDatabaseManager());
        for (Map.Entry entry : bindings.entrySet()) {
            this.addBinding((String)entry.getKey(), entry.getValue());
        }
        this.setLayout(new BorderLayout());
        this.menuBar = new MenuBar();
        this.setJMenuBar(this.menuBar);
        this.scriptTab.addChangeListener(new InternalChangeListener());
        ConsolePane initialPanel = new ConsolePane();
        this.initPanel(initialPanel);
        this.scriptTab.addTab("Console", initialPanel);
        this.add((Component)this.scriptTab, "Center");
        this.setResizable(true);
        this.pack();
    }

    private void addBinding(String key, Object value) {
        this.m_bindings.put(key, value);
    }

    private void initPanel(ConsolePane panel) {
        panel.setLanguage(this.defaultLanguage);
        panel.setProgressWindowTitle("Scripting");
        for (Map.Entry<String, Object> binding : this.m_bindings.entrySet()) {
            panel.addBinding(binding.getKey(), binding.getValue());
        }
        panel.setConsoleName("SCRIPT_CONSOLE");
        String string2 = this.scriptsDirectory;
        String string3 = String.valueOf(File.separator);
        panel.setLibraryPath(new StringBuilder(3 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append(string3).append("lib").toString());
    }

    private static class ScriptThread
    extends CEndlessHelperThread {
        private final ScriptEngine m_engine;
        private final File m_selectedFile;
        private final List<Pair<String, Object>> m_pairList;

        public ScriptThread(ScriptEngine engine, File selectedFile, List<Pair<String, Object>> bindings) {
            this.m_engine = engine;
            this.m_selectedFile = selectedFile;
            this.m_pairList = bindings;
        }

        @Override
        protected void runExpensiveCommand() throws Exception {
            ScriptRunner.runScript(this.m_engine, this.m_selectedFile, this.m_pairList);
        }

        @Override
        public void closeRequested() {
            this.finish();
        }
    }

    private class MenuBar
    extends ScriptingMenuBar {
        private MenuBar() {
        }

        private void executeScriptFile(File scriptFile) {
            List<Pair<String, Object>> bindings = this.toPairList(CScriptingDialog.this.m_bindings);
            ScriptEngineManager manager = new ScriptEngineManager();
            ScriptEngine engine = manager.getEngineByExtension(FileUtils.getFileExtension(scriptFile));
            ConsoleWriter console = new ConsoleWriter(new StringWriter());
            engine.getContext().setWriter(console.getWriter());
            bindings.add(new Pair<String, ConsoleWriter>("SCRIPT_CONSOLE", console));
            ScriptThread thread2 = new ScriptThread(engine, scriptFile, bindings);
            CProgressDialog.showEndless(CScriptingDialog.this.getOwner(), String.format("Executing '%s'", scriptFile.getAbsolutePath()), thread2);
            if (thread2.getException() != null) {
                CUtilityFunctions.logException(thread2.getException());
                String message2 = "E00108: Script file could not be executed";
                String description = CUtilityFunctions.createDescription(String.format("The script file '%s' could not be executed.", scriptFile.getAbsolutePath()), new String[]{"The script file is in use by another program and can not be read.", "You do not have sufficient rights to read the file", "The script contains a bug that caused an exception."}, new String[]{"BinNavi can not read the script file."});
                NaviErrorDialog.show(CScriptingDialog.this, "E00108: Script file could not be executed", description, thread2.getException());
            }
            IScriptPanel panel = (IScriptPanel)((Object)CScriptingDialog.this.scriptTab.getSelectedComponent());
            panel.setOutput(console.getOutput());
            CScriptingDialog.this.toFront();
        }

        private List<Pair<String, Object>> toPairList(Map<String, Object> bindings) {
            ArrayList<Pair<String, Object>> blist = new ArrayList<Pair<String, Object>>();
            for (Map.Entry<String, Object> pair : bindings.entrySet()) {
                blist.add(new Pair<String, Object>(pair.getKey(), pair.getValue()));
            }
            return blist;
        }

        @Override
        protected void closeTabMenuClicked() {
            Component activePanel = CScriptingDialog.this.scriptTab.getSelectedComponent();
            if (activePanel == null) {
                return;
            }
            CScriptingDialog.this.scriptTab.remove(activePanel);
        }

        @Override
        protected void copyMenuClicked() {
            ConsolePane panel = (ConsolePane)CScriptingDialog.this.scriptTab.getSelectedComponent();
            if (panel == null) {
                return;
            }
        }

        @Override
        protected void cutMenuClicked() {
            ConsolePane panel = (ConsolePane)CScriptingDialog.this.scriptTab.getSelectedComponent();
            if (panel == null) {
                return;
            }
        }

        @Override
        protected void executeAgainMenuClicked() {
            this.executeScriptFile(this.getLastExecutedScriptFile());
        }

        @Override
        protected void executeMenuClicked() {
            LastDirFileChooser chooser = new LastDirFileChooser();
            if (chooser.showOpenDialog(CScriptingDialog.this) == 0) {
                File selectedFile = chooser.getSelectedFile();
                this.executeScriptFile(selectedFile);
                this.setLastExecutedScriptFile(selectedFile);
            }
        }

        @Override
        protected void newConsoleTabMenuClicked() {
            ConsolePane panel = new ConsolePane();
            CScriptingDialog.this.initPanel(panel);
            CScriptingDialog.this.scriptTab.addTab("Console", panel);
            CScriptingDialog.this.scriptTab.setSelectedComponent(panel);
        }

        @Override
        protected void pasteMenuClicked() {
            ConsolePane panel = (ConsolePane)CScriptingDialog.this.scriptTab.getSelectedComponent();
            if (panel == null) {
                return;
            }
        }
    }

    private class InternalChangeListener
    implements ChangeListener {
        private InternalChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            Component currentTab = CScriptingDialog.this.scriptTab.getSelectedComponent();
            if (currentTab == null) {
                CScriptingDialog.this.dispose();
                return;
            }
            CScriptingDialog.this.menuBar.updateGui(currentTab instanceof ConsolePane);
        }
    }
}

