/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.ResolveFunctions;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Exceptions.MaybeNullException;
import com.google.security.zynamics.binnavi.Gui.Loaders.CModuleLoader;
import com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations.CFunctionHelpers;
import com.google.security.zynamics.binnavi.Gui.ResolveFunctions.CModuleWrapper;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.zylib.gui.CDialogEscaper;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.gui.CPanelTwoButtons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public final class CResolveFunctionDialog
extends JDialog {
    private static final long serialVersionUID = 5712062553289156840L;
    private final INaviModule m_module;
    private final JComboBox<String> m_parentBox;
    private final JComboBox<CModuleWrapper> m_targetModuleBox;

    public CResolveFunctionDialog(Window owner, IDatabase database, INaviModule module) {
        super(owner, "Resolve imported functions", Dialog.ModalityType.APPLICATION_MODAL);
        Preconditions.checkNotNull(database, "IE02062: Database argument can't be null");
        Preconditions.checkState(database.isLoaded(), "IE02063: Database must be loaded before functions can be redirected");
        this.m_module = Preconditions.checkNotNull(module, "IE02064: Module argument can't be null");
        Preconditions.checkState(module.isLoaded(), "IE02065: Module must be loaded before functions can be redirected");
        Preconditions.checkState(module.inSameDatabase(database), "IE02066: Module is not in the given database");
        this.setLayout(new BorderLayout());
        new CDialogEscaper(this);
        JPanel outerPanel = new JPanel(new BorderLayout());
        outerPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel innerPanel = new JPanel(new GridLayout(2, 3));
        innerPanel.setBorder(new LineBorder(Color.BLUE));
        innerPanel.add(CResolveFunctionDialog.createLabel("Source Module"));
        innerPanel.add(CResolveFunctionDialog.createLabel("Parent String"));
        innerPanel.add(CResolveFunctionDialog.createLabel("Target Module"));
        innerPanel.add(CResolveFunctionDialog.createLabel(module.getConfiguration().getName()));
        this.m_parentBox = new JComboBox<String>(CResolveFunctionDialog.generateParentBoxVector(module));
        this.m_parentBox.setBorder(new EmptyBorder(0, 5, 5, 5));
        innerPanel.add(this.m_parentBox);
        this.m_targetModuleBox = new JComboBox<CModuleWrapper>(CResolveFunctionDialog.generateTargetBoxVector(database, module));
        this.m_targetModuleBox.setBorder(new EmptyBorder(0, 5, 5, 5));
        innerPanel.add(this.m_targetModuleBox);
        outerPanel.add(innerPanel);
        this.add(outerPanel);
        this.add((Component)new CPanelTwoButtons(new InternalListener(), "Apply", "Close"), "South");
        this.pack();
    }

    private static JLabel createLabel(String string2) {
        JLabel label = new JLabel(string2);
        label.setBorder(new EmptyBorder(5, 5, 5, 5));
        return label;
    }

    private static Vector<String> generateParentBoxVector(INaviModule module) {
        HashSet<String> parents = new HashSet<String>();
        for (INaviFunction function : module.getContent().getFunctionContainer().getFunctions()) {
            String name = function.getOriginalModulename();
            if (name.equals(module.getConfiguration().getName())) continue;
            parents.add(name);
        }
        return new Vector<String>(parents);
    }

    private static Vector<CModuleWrapper> generateTargetBoxVector(IDatabase database, INaviModule sourceModule) {
        Vector<CModuleWrapper> wrappers = new Vector<CModuleWrapper>();
        for (INaviModule module : database.getContent().getModules()) {
            if (module == sourceModule) continue;
            wrappers.add(new CModuleWrapper(module));
        }
        return wrappers;
    }

    private void resolveFunctions() {
        Object selectedParentString = this.m_parentBox.getSelectedItem();
        if (selectedParentString == null) {
            return;
        }
        Object selectedModule = this.m_targetModuleBox.getSelectedItem();
        if (selectedModule == null) {
            return;
        }
        INaviModule targetModule = (INaviModule)((CModuleWrapper)selectedModule).getObject();
        if (!targetModule.isLoaded()) {
            if (CMessageBox.showYesNoQuestion(this, "The target module must be loaded before functions can be forwarded.\n\nDo you want to load the target module now?") == 1) {
                return;
            }
            CModuleLoader.loadModule(this, targetModule);
        }
        int counter = 0;
        String parentString = selectedParentString.toString();
        for (INaviFunction sourceFunction : this.m_module.getContent().getFunctionContainer().getFunctions()) {
            if (!sourceFunction.getOriginalModulename().equalsIgnoreCase(parentString) || !CFunctionHelpers.isForwardableFunction(sourceFunction)) continue;
            String sourceFunctionName = sourceFunction.getName();
            if (sourceFunctionName.startsWith("__imp_")) {
                sourceFunctionName = sourceFunctionName.substring("__imp_".length());
            }
            try {
                INaviFunction targetFunction = targetModule.getContent().getFunctionContainer().getFunction(sourceFunctionName);
                sourceFunction.setForwardedFunction(targetFunction);
                ++counter;
            }
            catch (MaybeNullException targetFunction) {
            }
            catch (CouldntSaveDataException exception) {
                CUtilityFunctions.logException(exception);
                String message2 = "E00023: Could not save function forwarding";
                String description = CUtilityFunctions.createDescription(String.format("Could not forward the function '%s' from module '%s' to module '%s'", sourceFunction.getName(), this.m_module.getConfiguration().getName(), targetModule.getConfiguration().getName()), new String[]{"The database connection was dropped while saving."}, new String[]{"The changes in function forwarding were not saved. Try saving function forwarding again. If necessary, close the connection to the database and reconnect."});
                NaviErrorDialog.show(this, "E00023: Could not save function forwarding", description, exception);
            }
        }
        if (counter == 0) {
            CMessageBox.showInformation(this, "No functions suitable for forwarding were found.");
        } else {
            CMessageBox.showInformation(this, String.format("%d functions were forwarded from module '%s' to module '%s'", counter, this.m_module.getConfiguration().getName(), targetModule.getConfiguration().getName()));
        }
    }

    private class InternalListener
    extends AbstractAction {
        private static final long serialVersionUID = -2029903028284147876L;

        private InternalListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getActionCommand().equals("Close")) {
                CResolveFunctionDialog.this.dispose();
            } else {
                CResolveFunctionDialog.this.resolveFunctions();
            }
        }
    }
}

