/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.ResolveFunctions;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.LoadCancelledException;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Exceptions.MaybeNullException;
import com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations.CFunctionHelpers;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.disassembly.INaviAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviProject;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;

public class CResolveAllFunctionDialog
extends JDialog {
    private static final long serialVersionUID = 8199639355220737061L;
    private final IDatabase m_database;
    private final List<INaviModule> m_targetModules;
    private final List<INaviModule> m_sourceModules;

    public CResolveAllFunctionDialog(Window owner, IDatabase database) {
        this.m_database = Preconditions.checkNotNull(database, "IE02352: Database argument can't be null");
        Preconditions.checkArgument(database.isLoaded(), "Error: Database must be loaded before functions can be redirected");
        this.m_targetModules = this.loadModules(this.m_database.getContent().getModules());
        this.m_sourceModules = this.loadModules(this.m_database.getContent().getModules());
        String message2 = String.format("Do you really want to resolve all functions in the database '%s'?", database.getConfiguration().getName());
        this.resultDialog(this.questionDialog(owner, message2));
    }

    public CResolveAllFunctionDialog(Window owner, IDatabase database, INaviAddressSpace addressSpace) {
        Preconditions.checkNotNull(addressSpace, "IE02353: addressSpace argument can not be null");
        this.m_database = Preconditions.checkNotNull(database, "IE02354: Database argument can't be null");
        Preconditions.checkArgument(database.isLoaded(), "Error: Database must be loaded before functions can be redirected");
        this.m_targetModules = this.loadModules(addressSpace.getContent().getModules());
        this.m_sourceModules = this.loadModules(addressSpace.getContent().getModules());
        String message2 = String.format("Do you really want to resolve all functions in the address space '%s'?", addressSpace.getConfiguration().getName());
        this.resultDialog(this.questionDialog(owner, message2));
    }

    public CResolveAllFunctionDialog(Window owner, IDatabase database, INaviModule module) {
        Preconditions.checkNotNull(module, "IE02355: module argument can not be null");
        this.m_database = Preconditions.checkNotNull(database, "IE02062: Database argument can't be null");
        Preconditions.checkArgument(database.isLoaded(), "IE02063: Database must be loaded before functions can be redirected");
        this.m_targetModules = this.loadModules(Lists.newArrayList(module));
        this.m_sourceModules = this.loadModules(database.getContent().getModules());
        String message2 = String.format("Do you really want to resolve all functions in the module '%s'?", module.getConfiguration().getName());
        this.resultDialog(this.questionDialog(owner, message2));
    }

    public CResolveAllFunctionDialog(Window owner, IDatabase database, INaviProject project) {
        Preconditions.checkNotNull(project, "IE02356: project argument can not be null");
        this.m_database = Preconditions.checkNotNull(database, "IE02357: Database argument can't be null");
        Preconditions.checkArgument(database.isLoaded(), "Error: Database must be loaded before functions can be redirected");
        String message2 = String.format("Do you really want to resolve all functions in the project '%s'?", project.getConfiguration().getName());
        this.m_targetModules = new ArrayList<INaviModule>();
        this.m_sourceModules = new ArrayList<INaviModule>();
        for (INaviAddressSpace addressSpace : project.getContent().getAddressSpaces()) {
            this.m_targetModules.addAll(this.loadModules(addressSpace.getContent().getModules()));
            this.m_sourceModules.addAll(this.loadModules(addressSpace.getContent().getModules()));
        }
        this.resultDialog(this.questionDialog(owner, message2));
    }

    private static void exceptionDialog(INaviModule currentModule, JDialog dialog, CouldntLoadDataException exception) {
        CUtilityFunctions.logException(exception);
        String message2 = "Error: Could not load function forwarding";
        String description = CUtilityFunctions.createDescription(String.format("Could not load '%s'", currentModule.getConfiguration().getName()), new String[]{"The database connection was dropped while saving."}, new String[]{"The changes in function forwarding were not saved. Try saving function forwarding again. If necessary, close the connection to the database and reconnect."});
        NaviErrorDialog.show(dialog, "Error: Could not load function forwarding", description, exception);
    }

    private List<INaviModule> loadModules(List<INaviModule> modules) {
        ArrayList<INaviModule> loadedModules = new ArrayList<INaviModule>();
        for (INaviModule currentModule : modules) {
            if (!currentModule.isLoaded()) {
                try {
                    currentModule.load();
                }
                catch (CouldntLoadDataException exception) {
                    CResolveAllFunctionDialog.exceptionDialog(currentModule, this, exception);
                }
                catch (LoadCancelledException loadCancelledException) {
                    // empty catch block
                }
            }
            loadedModules.add(currentModule);
        }
        return loadedModules;
    }

    private int questionDialog(Window owner, String message2) {
        if (0 == CMessageBox.showYesNoCancelQuestion(owner, message2)) {
            return this.resolveAllFunctions();
        }
        return 0;
    }

    private int resolveAllFunctions() {
        int counter = 0;
        for (INaviModule currentModule : this.m_targetModules) {
            for (INaviFunction currentFunction : currentModule.getContent().getFunctionContainer().getFunctions()) {
                String originalName = currentFunction.getOriginalModulename();
                if (originalName.equalsIgnoreCase(currentModule.getConfiguration().getName()) || originalName.equalsIgnoreCase("")) continue;
                for (INaviModule targetModule : this.m_sourceModules) {
                    String targetModuleName = targetModule.getConfiguration().getName();
                    if (!targetModuleName.toUpperCase().contains(originalName.toUpperCase()) || !CFunctionHelpers.isForwardableFunction(currentFunction) || currentFunction.getForwardedFunctionModuleId() != 0) continue;
                    String currentFunctionName = currentFunction.getName();
                    if (currentFunctionName.startsWith("__imp_")) {
                        currentFunctionName = currentFunctionName.substring("__imp_".length());
                    }
                    try {
                        INaviFunction targetFunction = targetModule.getContent().getFunctionContainer().getFunction(currentFunctionName);
                        currentFunction.setForwardedFunction(targetFunction);
                        ++counter;
                    }
                    catch (MaybeNullException targetFunction) {
                    }
                    catch (CouldntSaveDataException exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
            }
        }
        return counter;
    }

    private void resultDialog(int counter) {
        if (counter == 0) {
            return;
        }
        int n2 = this.m_targetModules.size();
        CMessageBox.showInformation(this.getParent(), new StringBuilder(54).append("Forwared ").append(counter).append(" functions in ").append(n2).append(" modules.").toString());
    }
}

