/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Progress;

import com.google.security.zynamics.binnavi.Gui.CIconInitializer;
import com.google.security.zynamics.binnavi.Gui.Progress.CGlobalProgressManager;
import com.google.security.zynamics.binnavi.Gui.Progress.IGlobalProgressManagerListener;
import com.google.security.zynamics.binnavi.Gui.Progress.IProgressOperation;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public final class CGlobalProgressDialog
extends JDialog {
    private static final long serialVersionUID = -8241186630373844927L;
    private final JPanel m_progressPanel = new JPanel(new GridBagLayout());
    private final IGlobalProgressManagerListener m_listener = new IGlobalProgressManagerListener(){

        @Override
        public void added(IProgressOperation operation) {
            CGlobalProgressDialog.this.add(operation);
        }

        @Override
        public void removed(IProgressOperation operation) {
            CGlobalProgressDialog.this.remove(operation);
        }
    };
    private int counter = 0;

    public CGlobalProgressDialog() {
        super((Window)null, "Ongoing operations");
        CIconInitializer.initializeWindowIcons(this);
        this.setLayout(new BorderLayout());
        JPanel innerPanel = new JPanel(new BorderLayout());
        JPanel upperPanel = new JPanel(new BorderLayout());
        upperPanel.add((Component)this.m_progressPanel, "North");
        innerPanel.add(new JScrollPane(upperPanel));
        this.add(innerPanel);
        JPanel lowerPanel = new JPanel(new BorderLayout());
        lowerPanel.add((Component)new JButton(new CHideAction()), "East");
        this.add((Component)lowerPanel, "South");
        this.setSize(400, 300);
        GuiHelper.centerOnScreen(this);
        this.setDefaultCloseOperation(1);
        for (IProgressOperation operation : CGlobalProgressManager.instance().getOperations()) {
            this.add(operation);
        }
        this.setFocusable(false);
        CGlobalProgressManager.instance().addListener(this.m_listener);
    }

    private void add(IProgressOperation operation) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.gridy = this.counter++;
        constraints.gridx = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        this.m_progressPanel.add((Component)operation.getProgressPanel(), constraints);
    }

    private void remove(IProgressOperation operation) {
        this.m_progressPanel.remove(operation.getProgressPanel());
        if (this.m_progressPanel.getComponentCount() == 0) {
            this.setVisible(false);
        }
    }

    private final class CHideAction
    extends AbstractAction {
        private static final long serialVersionUID = 20541718054084944L;

        public CHideAction() {
            super("Hide");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CGlobalProgressDialog.this.setVisible(false);
        }
    }
}

