/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ViewSearcher;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.Debug.GraphSelectionDialog.CGraphSelectionTableModel;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ViewSearcher.SearchAction;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.disassembly.UnrelocatedAddress;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainer;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.gui.CDialogEscaper;
import com.google.security.zynamics.zylib.gui.CHexFormatter;
import com.google.security.zynamics.zylib.gui.CPanelTwoButtons;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.text.DefaultFormatterFactory;

public final class CViewSearcherDialog
extends JDialog {
    private static final long serialVersionUID = 6689975974705708788L;
    private final IViewContainer m_viewContainer;
    private INaviView m_selectionResult = null;
    private JTable m_table;
    private final CGraphSelectionTableModel tableModel = new CGraphSelectionTableModel(new ArrayList<INaviView>());
    private final JFormattedTextField m_offsetField = new JFormattedTextField(new DefaultFormatterFactory(new CHexFormatter(8)));
    private final InternalListener m_listener = new InternalListener();

    public CViewSearcherDialog(Window owner, IViewContainer viewContainer, IAddress address) {
        super(owner, "Select a graph", Dialog.ModalityType.APPLICATION_MODAL);
        Preconditions.checkNotNull(viewContainer, "IE02057: View container can't be null");
        this.m_viewContainer = viewContainer;
        this.createGui();
        new CDialogEscaper(this);
        GuiHelper.centerChildToParent(owner, this, true);
        if (address != null) {
            this.m_offsetField.setText(address.toHexString());
            this.search(address.toLong());
        }
    }

    private void closeDialog() {
        this.m_table.removeMouseListener(this.m_listener);
        this.dispose();
    }

    private void createGui() {
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel(new BorderLayout());
        JLabel lbl = new JLabel("Address:");
        lbl.setBorder(new EmptyBorder(5, 5, 5, 5));
        panel.add((Component)lbl, "West");
        this.m_offsetField.setSize(400, 20);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                CViewSearcherDialog.this.search();
            }
        };
        this.m_offsetField.addActionListener(listener);
        panel.add((Component)this.m_offsetField, "Center");
        panel.add((Component)new JButton(CActionProxy.proxy(new SearchAction(this))), "East");
        this.add((Component)panel, "North");
        this.m_table = new JTable(this.tableModel);
        this.m_table.addMouseListener(this.m_listener);
        this.add((Component)new JScrollPane(this.m_table), "Center");
        this.add((Component)new CPanelTwoButtons(CActionProxy.proxy(new InternalActionListener()), "OK", "Cancel"), "South");
        this.setSize(500, 300);
    }

    private void search(long offset) {
        try {
            this.tableModel.setViews(this.m_viewContainer.getViewsWithAddresses(Lists.newArrayList(new UnrelocatedAddress(new CAddress(offset))), true));
        }
        catch (CouldntLoadDataException e2) {
            CUtilityFunctions.logException(e2);
            String innerMessage = "E00190: Could not search views";
            String innerDescription = CUtilityFunctions.createDescription(String.format("BinNavi could not determine what views contain the offset '%s'.", new CAddress(offset).toHexString()), new String[]{"There was a problem with the database connection."}, new String[]{"The views with the given address can not be shown."});
            NaviErrorDialog.show(null, "E00190: Could not search views", innerDescription, e2);
        }
    }

    private void setSelectedElement() {
        int selectedRow = this.m_table.getSelectedRow();
        if (selectedRow != -1) {
            CGraphSelectionTableModel model = (CGraphSelectionTableModel)this.m_table.getModel();
            this.m_selectionResult = model.getViews().get(selectedRow);
        }
    }

    public INaviView getSelectionResult() {
        return this.m_selectionResult;
    }

    public void search() {
        long offset = Long.valueOf(this.m_offsetField.getText(), 16);
        this.search(offset);
    }

    private class InternalListener
    extends MouseAdapter {
        private InternalListener() {
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (event.getButton() == 1 && event.getClickCount() == 2) {
                CViewSearcherDialog.this.setSelectedElement();
            }
            if (CViewSearcherDialog.this.m_selectionResult != null) {
                CViewSearcherDialog.this.closeDialog();
            }
        }
    }

    private class InternalActionListener
    extends AbstractAction {
        private static final long serialVersionUID = -3385023274674137932L;

        private InternalActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getActionCommand().equals("OK")) {
                CViewSearcherDialog.this.setSelectedElement();
            }
            CViewSearcherDialog.this.closeDialog();
        }
    }
}

