/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.filters.Views;

import com.google.security.zynamics.binnavi.CMain;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.IFilter;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.IFilterComponent;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.IFilterComponentListener;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.filters.Functions.IFilterDialogListener;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.filters.Views.CViewFilterDialog;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.filters.Views.CViewTypePanel;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainer;
import com.google.security.zynamics.zylib.disassembly.GraphType;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.types.common.CollectionHelpers;
import com.google.security.zynamics.zylib.types.common.ICollectionFilter;
import com.google.security.zynamics.zylib.types.lists.FilledList;
import com.google.security.zynamics.zylib.types.lists.IFilledList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;

public final class CViewFilterComponent
extends JPanel
implements IFilterComponent<INaviView> {
    private final CViewFilterDialog m_dialog;
    private final IFilterDialogListener m_filterDialogListener = new InternalFilterDialogListener();
    private final ListenerProvider<IFilterComponentListener> m_listeners = new ListenerProvider();

    public CViewFilterComponent(IViewContainer module) {
        super(new BorderLayout());
        if (GraphicsEnvironment.isHeadless()) {
            this.m_dialog = null;
        } else {
            this.m_dialog = new CViewFilterDialog(module.getDatabase().getContent().getViewTagManager(), module.getDatabase().getContent().getNodeTagManager());
            this.m_dialog.addListener(this.m_filterDialogListener);
        }
        this.add(new JButton(new CFilterAction()));
    }

    @Override
    public void addListener(IFilterComponentListener listener) {
        this.m_listeners.addListener(listener);
    }

    @Override
    public IFilter<INaviView> createFilter() {
        return new IFilter<INaviView>(){

            @Override
            public boolean checkCondition(INaviView element) {
                CViewTypePanel typePanel = CViewFilterComponent.this.m_dialog.getViewTypePanel();
                return typePanel.isShowCallgraphViews() && element.getGraphType() == GraphType.CALLGRAPH || typePanel.isShowMixedViews() && element.getGraphType() == GraphType.MIXED_GRAPH || typePanel.isShowFlowgraphViews() && element.getGraphType() == GraphType.FLOWGRAPH;
            }

            @Override
            public IFilledList<INaviView> get(List<INaviView> elements) {
                return new FilledList<INaviView>((Collection<INaviView>)CollectionHelpers.filter(elements, new ICollectionFilter<INaviView>(){

                    @Override
                    public boolean qualifies(INaviView item) {
                        return this.checkCondition(item);
                    }
                }));
            }
        };
    }

    public void dispose() {
        if (this.m_dialog != null) {
            this.m_dialog.removeListener(this.m_filterDialogListener);
        }
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void removeListener(IFilterComponentListener listener) {
        this.m_listeners.removeListener(listener);
    }

    private class InternalFilterDialogListener
    implements IFilterDialogListener {
        private InternalFilterDialogListener() {
        }

        @Override
        public void updated() {
            for (IFilterComponentListener listener : CViewFilterComponent.this.m_listeners) {
                listener.updated();
            }
        }
    }

    private class CFilterAction
    extends AbstractAction {
        public CFilterAction() {
            super("", new ImageIcon(CMain.class.getResource("data/funnel.png")));
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            int y2 = CViewFilterComponent.this.getLocationOnScreen().y - CViewFilterComponent.this.m_dialog.getHeight() + CViewFilterComponent.this.getHeight();
            if (y2 < 0) {
                y2 = 0;
            }
            CViewFilterComponent.this.m_dialog.setLocation(CViewFilterComponent.this.getLocationOnScreen().x + CViewFilterComponent.this.getWidth(), y2);
            CViewFilterComponent.this.m_dialog.setVisible(true);
        }
    }
}

