/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Views.Project.Component;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractNodeComponent;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Views.CUserViewsComponent;
import com.google.security.zynamics.binnavi.disassembly.CProject;
import com.google.security.zynamics.binnavi.disassembly.CProjectListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.INaviProject;
import com.google.security.zynamics.binnavi.disassembly.views.CViewFilter;
import com.google.security.zynamics.binnavi.disassembly.views.CViewListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainer;
import com.google.security.zynamics.zylib.disassembly.GraphType;
import java.awt.BorderLayout;
import java.util.List;
import javax.swing.JTree;
import javax.swing.border.TitledBorder;

public final class CProjectViewsContainerComponent
extends CAbstractNodeComponent {
    private static final long serialVersionUID = -6539823583498119807L;
    private final INaviProject m_project;
    private final TitledBorder m_flowgraphBorder = new TitledBorder("");
    private final TitledBorder m_callgraphBorder = new TitledBorder("");
    private final TitledBorder m_mixedgraphBorder = new TitledBorder("");
    private final InternalProjectListener m_viewContainerListener = new InternalProjectListener();
    private final InternalViewListener m_viewListener = new InternalViewListener();

    public CProjectViewsContainerComponent(JTree projectTree, INaviProject project, IViewContainer container) {
        super(new BorderLayout());
        Preconditions.checkNotNull(projectTree, "IE02053: Project tree argument can not be null");
        Preconditions.checkNotNull(project, "IE02054: Project argument can not be null");
        Preconditions.checkNotNull(container, "IE02055: Container argument can not be null");
        this.m_project = project;
        this.add(new CUserViewsComponent(projectTree, container));
        this.updateBorderText();
        this.m_project.addListener(this.m_viewContainerListener);
        for (INaviView view : project.getContent().getViews()) {
            view.addListener(this.m_viewListener);
        }
    }

    private void updateBorderText() {
        List<INaviView> views = this.m_project.getContent().getViews();
        this.m_callgraphBorder.setTitle(String.format("%d Call graph Views", CViewFilter.getCallgraphViewCount(views)));
        this.m_flowgraphBorder.setTitle(String.format("%d Flow graph Views", CViewFilter.getFlowgraphViewCount(views)));
        this.m_mixedgraphBorder.setTitle(String.format("%d Mixed graph Views", CViewFilter.getMixedgraphViewCount(views)));
        this.updateUI();
    }

    @Override
    public void dispose() {
        this.m_project.removeListener(this.m_viewContainerListener);
        if (this.m_project.isLoaded()) {
            for (INaviView view : this.m_project.getContent().getViews()) {
                view.removeListener(this.m_viewListener);
            }
        }
    }

    private class InternalViewListener
    extends CViewListenerAdapter {
        private InternalViewListener() {
        }

        @Override
        public void changedGraphType(INaviView view, GraphType type, GraphType oldType) {
            CProjectViewsContainerComponent.this.updateBorderText();
        }
    }

    private class InternalProjectListener
    extends CProjectListenerAdapter {
        private InternalProjectListener() {
        }

        @Override
        public void addedView(INaviProject container, INaviView view) {
            CProjectViewsContainerComponent.this.updateBorderText();
            view.addListener(CProjectViewsContainerComponent.this.m_viewListener);
        }

        @Override
        public void deletedView(INaviProject moduleContainer, INaviView view) {
            CProjectViewsContainerComponent.this.updateBorderText();
            view.removeListener(CProjectViewsContainerComponent.this.m_viewListener);
        }

        @Override
        public void loadedProject(CProject container) {
            CProjectViewsContainerComponent.this.updateBorderText();
        }
    }
}

