/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Views.Component;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.HotKeys;
import com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations.CShowViewFunctions;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.DragAndDrop.CViewDragHandler;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractTreeTable;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractTreeViewsTableModel;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Views.Component.Actions.COpenInLastWindowAction;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Views.Component.CViewPopupMenu;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Views.Component.CViewsTableRenderer;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Views.Component.IViewsTable;
import com.google.security.zynamics.binnavi.Help.IHelpInformation;
import com.google.security.zynamics.binnavi.ZyGraph.Builders.GraphBuilderEvents;
import com.google.security.zynamics.binnavi.ZyGraph.Builders.IGraphBuilderListener;
import com.google.security.zynamics.binnavi.ZyGraph.Builders.IGraphBuilderManagerListener;
import com.google.security.zynamics.binnavi.ZyGraph.Builders.ZyGraphBuilderManager;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainer;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.Builders.ZyGraphBuilder;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JPopupMenu;
import javax.swing.JTree;

public abstract class CViewsTable
extends CAbstractTreeTable<INaviView>
implements IViewsTable {
    private final CAbstractTreeViewsTableModel viewsTableModel;
    private final IViewContainer viewContainer;
    private final IGraphBuilderListener graphBuilderListener = new IGraphBuilderListener(){

        @Override
        public boolean building(GraphBuilderEvents event, int counter) {
            return true;
        }
    };
    private final IGraphBuilderManagerListener builderManagerListener = new IGraphBuilderManagerListener(){

        @Override
        public void addedBuilder(INaviView view, ZyGraphBuilder builder) {
            builder.addListener(CViewsTable.this.graphBuilderListener);
        }

        @Override
        public void removedBuilder(INaviView view, ZyGraphBuilder builder) {
            builder.removeListener(CViewsTable.this.graphBuilderListener);
        }
    };

    public CViewsTable(JTree projectTree, CAbstractTreeViewsTableModel model, IViewContainer container, IHelpInformation helpInfo) {
        super(projectTree, model, helpInfo);
        this.viewContainer = Preconditions.checkNotNull(container, "IE02031: Container argument can not be null");
        this.viewsTableModel = Preconditions.checkNotNull(model, "IE02350: model argument can not be null");
        if (!GraphicsEnvironment.isHeadless()) {
            this.setDragEnabled(true);
        }
        this.setTransferHandler(new CViewDragHandler(this));
        InputMap windowImap = this.getInputMap(0);
        windowImap.put(HotKeys.LOAD_NEW_WINDOW_HK.getKeyStroke(), "ShowNewKeyStroke");
        this.getActionMap().put("ShowNewKeyStroke", CActionProxy.proxy(new ShowNewWindowAction()));
        windowImap.put(HotKeys.LOAD_LAST_WINDOW_HK.getKeyStroke(), "ShowLastKeyStroke");
        this.getActionMap().put("ShowLastKeyStroke", CActionProxy.proxy(new ShowLastWindowAction()));
        ZyGraphBuilderManager.instance().addListener(this.builderManagerListener);
    }

    private INaviView[] getSelectedViews(int sortedRow) {
        int[] sortSelectedRows = this.getSortSelectedRows();
        if (Ints.contains(sortSelectedRows, sortedRow)) {
            return this.getViews(sortSelectedRows);
        }
        int viewRow = this.convertRowIndexToView(sortedRow);
        this.setRowSelectionInterval(viewRow, viewRow);
        return this.getViews(new int[]{sortedRow});
    }

    @Override
    protected JPopupMenu getPopupMenu(int x2, int y2, int row) {
        return new CViewPopupMenu(this.getParentWindow(), this, this.viewContainer, this.getSelectedViews(row), x2, y2);
    }

    @Override
    protected void handleDoubleClick(int row) {
        Action action = CActionProxy.proxy(new COpenInLastWindowAction(this.getParentWindow(), this.viewContainer, new INaviView[]{this.viewsTableModel.getViews().get(row)}));
        action.actionPerformed(null);
    }

    @Override
    public void dispose() {
        super.dispose();
        ((CViewsTableRenderer)this.getDefaultRenderer(Object.class)).dispose();
        ZyGraphBuilderManager.instance().removeListener(this.builderManagerListener);
    }

    @Override
    public int getNameColumn() {
        return 0;
    }

    @Override
    public CAbstractTreeViewsTableModel getTreeTableModel() {
        return this.viewsTableModel;
    }

    @Override
    public INaviView getUnsortedView(int row) {
        return this.getTreeTableModel().getViews().get(this.convertRowIndexToModel(row));
    }

    public INaviView[] getViews(int[] rows) {
        INaviView[] views = new INaviView[rows.length];
        for (int i2 = 0; i2 < views.length; ++i2) {
            views[i2] = this.viewsTableModel.getViews().get(rows[i2]);
        }
        return views;
    }

    private class ShowNewWindowAction
    extends AbstractAction {
        private ShowNewWindowAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CShowViewFunctions.showViewInNewWindow(CViewsTable.this.getParentWindow(), CViewsTable.this.viewContainer, CViewsTable.this.getViews(CViewsTable.this.getSortSelectedRows()));
        }
    }

    private class ShowLastWindowAction
    extends AbstractAction {
        private ShowLastWindowAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CShowViewFunctions.showViewInLastWindow(CViewsTable.this.getParentWindow(), CViewsTable.this.viewContainer, CViewsTable.this.getViews(CViewsTable.this.getSortSelectedRows()));
        }
    }
}

