/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Views.Component;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphWindow;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.IGraphContainerWindow;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.IGraphPanel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Implementations.CGraphDebugger;
import com.google.security.zynamics.binnavi.Gui.HotKeys;
import com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations.CFunctionHelpers;
import com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations.CShowViewFunctions;
import com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations.CViewContainerFunctions;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CRemoveFunctionBreakpointsAction;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CSearchTableAction;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CSetFunctionBreakpointsAction;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CStarViewsAction;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CToggleStarViewsAction;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CUnstarViewAction;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Views.Component.Actions.COpenInLastWindowAction;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Views.Component.Actions.CRenameBackAction;
import com.google.security.zynamics.binnavi.Gui.WindowManager.CWindowManager;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.IStaredItem;
import com.google.security.zynamics.binnavi.disassembly.UnrelocatedAddress;
import com.google.security.zynamics.binnavi.disassembly.algorithms.CStaredItemFunctions;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainer;
import com.google.security.zynamics.zylib.disassembly.FunctionType;
import com.google.security.zynamics.zylib.disassembly.ViewType;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.gui.tables.CopyCellAction;
import com.google.security.zynamics.zylib.gui.tables.CopySelectionAction;
import com.google.security.zynamics.zylib.types.lists.FilledList;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTable;

public class CViewPopupMenu
extends JPopupMenu {
    public CViewPopupMenu(Window parent, JTable table, IViewContainer container, INaviView[] views, int x2, int y2) {
        boolean singleSelection;
        Preconditions.checkNotNull(container, "IE02029: Container can't be null");
        Preconditions.checkNotNull(views, "IE02030: View argument can't be null");
        List<CGraphWindow> windows = CWindowManager.instance().getOpenWindows();
        if (!windows.isEmpty()) {
            this.add(CActionProxy.proxy(new COpenInLastWindowAction(parent, container, views)));
        }
        this.add(CActionProxy.proxy(new OpenInNewWindowAction(parent, container, views)));
        if (!windows.isEmpty()) {
            JMenu openInItem = new JMenu("Open in window ...");
            for (CGraphWindow graphContainer : windows) {
                openInItem.add(CActionProxy.proxy(new OpenInWindowAction(parent, container, views, graphContainer)));
            }
            this.add(openInItem);
        }
        this.addSeparator();
        if (CStaredItemFunctions.allStared((IStaredItem[])views)) {
            this.add(CActionProxy.proxy(new CUnstarViewAction(parent, views)));
        } else if (CStaredItemFunctions.allNotStared((IStaredItem[])views)) {
            this.add(CActionProxy.proxy(new CStarViewsAction(parent, views)));
        } else {
            this.add(CActionProxy.proxy(new CToggleStarViewsAction(parent, views)));
        }
        if (this.canDelete(views)) {
            this.addSeparator();
            this.add(CActionProxy.proxy(new DeleteViewAction(parent, container, views)));
        }
        boolean bl2 = singleSelection = views.length == 1;
        if (singleSelection) {
            INaviView view = views[0];
            INaviFunction function = container.getFunction(view);
            if (function != null && CFunctionHelpers.isForwardableFunction(function)) {
                this.addSeparator();
                if (function.getForwardedFunctionAddress() == null) {
                    this.add(CActionProxy.proxy(new CConnectFunctionAction(parent, container.getDatabase(), function)));
                } else {
                    this.add(CActionProxy.proxy(new CRemoveConnectedFunctionAction(parent, function)));
                }
            }
            if (function != null && !function.getName().equals(function.getOriginalName())) {
                this.addSeparator();
                this.add(CActionProxy.proxy(new CRenameBackAction(parent, view, function.getOriginalName())));
            }
        }
        this.addSeparator();
        ArrayList<INaviFunction> functions = new ArrayList<INaviFunction>();
        boolean anyNull = false;
        for (INaviView view : views) {
            INaviFunction func = container.getFunction(view);
            boolean bl3 = anyNull = func == null;
            if (anyNull) break;
            functions.add(func);
        }
        if (!anyNull) {
            ArrayList<IDebugger> debuggers = new ArrayList<IDebugger>();
            anyNull = false;
            for (INaviFunction func : functions) {
                IDebugger dbg = container.getDebuggerProvider().getDebugger(func.getModule());
                boolean bl4 = anyNull = dbg == null;
                if (anyNull) break;
                debuggers.add(dbg);
            }
            if (!anyNull) {
                FilledList<Pair<IDebugger, INaviFunction>> pairs = new FilledList<Pair<IDebugger, INaviFunction>>();
                for (int i2 = 0; i2 < debuggers.size(); ++i2) {
                    pairs.add(new Pair(debuggers.get(i2), functions.get(i2)));
                }
                if (singleSelection) {
                    if (((INaviFunction)((Pair)pairs.get(0)).second()).getType() != FunctionType.IMPORT) {
                        if (CGraphDebugger.hasBreakpoint(((IDebugger)((Pair)pairs.get(0)).first()).getBreakpointManager(), ((INaviFunction)((Pair)pairs.get(0)).second()).getModule(), new UnrelocatedAddress(((INaviFunction)((Pair)pairs.get(0)).second()).getAddress()))) {
                            this.add(CActionProxy.proxy(new CRemoveFunctionBreakpointsAction(pairs)));
                        } else {
                            this.add(CActionProxy.proxy(new CSetFunctionBreakpointsAction(pairs)));
                        }
                        this.addSeparator();
                    }
                } else {
                    this.add(CActionProxy.proxy(new CSetFunctionBreakpointsAction(pairs)));
                    this.add(CActionProxy.proxy(new CRemoveFunctionBreakpointsAction(pairs)));
                    this.addSeparator();
                }
            }
        }
        this.add(CActionProxy.proxy(new CopySelectionAction(table)));
        this.add(CActionProxy.proxy(new CopyCellAction(table, x2, y2)));
        this.add(new JSeparator());
        this.add(new JMenuItem(CActionProxy.proxy(new CSearchTableAction(parent, table))));
    }

    private static List<Pair<INaviView, List<INaviView>>> getDerivedViews(INaviView[] views) throws CouldntLoadDataException {
        ArrayList<Pair<INaviView, List<INaviView>>> derivedViews = new ArrayList<Pair<INaviView, List<INaviView>>>();
        for (INaviView view : views) {
            derivedViews.add(new Pair<INaviView, List<INaviView>>(view, view.getDerivedViews()));
        }
        return derivedViews;
    }

    private boolean canDelete(INaviView[] views) {
        for (INaviView view : views) {
            if (view.getType() == ViewType.NonNative) continue;
            return false;
        }
        return true;
    }

    private static class OpenInWindowAction
    extends AbstractAction {
        private final Window parentWindow;
        private final IViewContainer viewContainer;
        private final INaviView[] views;
        private final CGraphWindow graphWindow;

        public OpenInWindowAction(Window parent, IViewContainer container, INaviView[] views, CGraphWindow graphWindow) {
            super(OpenInWindowAction.createTitle(graphWindow));
            this.parentWindow = Preconditions.checkNotNull(parent, "IE02380: parent argument can not be null");
            this.viewContainer = Preconditions.checkNotNull(container, "IE02381: container argument can not be null");
            this.views = (INaviView[])Preconditions.checkNotNull(views.clone(), "Error: views.clone() argument can not be null");
            this.graphWindow = Preconditions.checkNotNull(graphWindow, "IE02382: graphWindow argument can not be null");
        }

        private static String createTitle(IGraphContainerWindow graphWindow) {
            int counter = 0;
            StringBuffer ret = new StringBuffer();
            boolean addSlash = false;
            for (IGraphPanel window : graphWindow) {
                if (addSlash) {
                    ret.append('/');
                }
                addSlash = true;
                INaviView view = window.getModel().getGraph().getRawView();
                String viewName = view.getName();
                ret.append(viewName);
                if (++counter != 3 || graphWindow.getOpenGraphCount() == 3) continue;
                ret.append("/...");
                break;
            }
            return ret.toString();
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CShowViewFunctions.showViews(this.parentWindow, this.viewContainer, this.views, this.graphWindow);
        }
    }

    private static class OpenInNewWindowAction
    extends AbstractAction {
        private final Window parentWindow;
        private final IViewContainer viewContainer;
        private final INaviView[] views;

        public OpenInNewWindowAction(Window parent, IViewContainer container, INaviView[] views) {
            super("Open in new window");
            this.parentWindow = Preconditions.checkNotNull(parent, "IE02378: parent argument can not be null");
            this.viewContainer = Preconditions.checkNotNull(container, "IE02379: container argument can not be null");
            this.views = (INaviView[])Preconditions.checkNotNull(views, "IE02875: views argument can not be null").clone();
            this.putValue("AcceleratorKey", HotKeys.LOAD_NEW_WINDOW_HK.getKeyStroke());
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CShowViewFunctions.showViewInNewWindow(this.parentWindow, this.viewContainer, this.views);
        }
    }

    private static class DeleteViewAction
    extends AbstractAction {
        private final Window parentWindow;
        private final IViewContainer viewContainer;
        private final INaviView[] views;

        public DeleteViewAction(Window parent, IViewContainer viewContainer, INaviView[] views) {
            super("Delete View");
            this.parentWindow = Preconditions.checkNotNull(parent, "IE02260: parent argument can not be null");
            this.views = (INaviView[])Preconditions.checkNotNull(views.clone(), "IE03413: views.clone() argument can not be null");
            this.viewContainer = Preconditions.checkNotNull(viewContainer, "IE02297: viewContainer argument can not be null");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CViewContainerFunctions.deleteViews(this.parentWindow, this.viewContainer, this.views);
        }
    }

    private static class CRemoveConnectedFunctionAction
    extends AbstractAction {
        private final Window parentWindow;
        private final INaviFunction function;

        public CRemoveConnectedFunctionAction(Window parent, INaviFunction function) {
            super("Remove function forwarding");
            this.parentWindow = parent;
            this.function = function;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CFunctionHelpers.removeResolvedFunction(this.parentWindow, this.function);
        }
    }

    private static class CConnectFunctionAction
    extends AbstractAction {
        private final Window parentWindow;
        private final IDatabase database;
        private final INaviFunction function;

        public CConnectFunctionAction(Window parent, IDatabase database, INaviFunction function) {
            super("Resolve Imported Function");
            this.parentWindow = parent;
            this.database = database;
            this.function = function;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CFunctionHelpers.resolveFunction(this.parentWindow, this.database, this.function);
        }
    }
}

