/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Views.Component;

import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.IFilter;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractTreeViewsTableModel;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.disassembly.INaviEdge;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.algorithms.CStaredItemFunctions;
import com.google.security.zynamics.binnavi.disassembly.views.CViewListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainer;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainerListener;
import com.google.security.zynamics.zylib.disassembly.GraphType;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.general.comparators.IntComparator;
import com.google.security.zynamics.zylib.types.graphs.IDirectedGraph;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.Timer;

public final class CUserViewsModel
extends CAbstractTreeViewsTableModel {
    private static final long serialVersionUID = 6101658647465016518L;
    private static final String[] COLUMN_NAMES = new String[]{"Name", "Description", "Nodes", "Edges", "Creation Date", "Modification Date"};
    private static final int NAME_COLUMN = 0;
    private static final int DESCRIPTION_COLUMN = 1;
    private static final int NODE_COUNT_COLUMN = 2;
    private static final int EDGE_COUNT_COLUMN = 3;
    private static final int CREATION_DATE_COLUMN = 4;
    private static final int MODIFICATION_DATE_COLUMN = 5;
    private final IViewContainer m_originContainer;
    private final CViewTableListener m_listener;
    private List<INaviView> m_cachedViews = null;

    public CUserViewsModel(IViewContainer originContainer) {
        this.m_originContainer = originContainer;
        this.m_listener = new CViewTableListener();
    }

    @Override
    public void delete() {
        this.m_listener.dispose();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    @Override
    public int getRowCount() {
        return this.getViews().size();
    }

    @Override
    public List<Pair<Integer, Comparator<?>>> getSorters() {
        ArrayList sorters = new ArrayList();
        sorters.add(new Pair<Integer, IntComparator>(2, new IntComparator()));
        sorters.add(new Pair<Integer, IntComparator>(3, new IntComparator()));
        return sorters;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        List<INaviView> views = this.m_cachedViews == null ? this.getViews() : this.m_cachedViews;
        INaviView view = views.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return view.getName();
            }
            case 1: {
                return view.getConfiguration().getDescription();
            }
            case 2: {
                return view.getNodeCount();
            }
            case 3: {
                return view.getEdgeCount();
            }
            case 4: {
                return view.getConfiguration().getCreationDate();
            }
            case 5: {
                return view.getConfiguration().getModificationDate();
            }
        }
        throw new IllegalStateException("IE02244: Unknown column");
    }

    @Override
    public List<INaviView> getViews() {
        List<INaviView> localCachedViews = this.m_cachedViews;
        if (localCachedViews == null) {
            IFilter<INaviView> filter = this.getFilter();
            localCachedViews = this.m_originContainer.isLoaded() ? (filter == null ? this.m_originContainer.getUserViews() : filter.get(this.m_originContainer.getUserViews())) : new ArrayList<INaviView>();
        }
        CStaredItemFunctions.sort(localCachedViews);
        this.m_cachedViews = localCachedViews;
        return new ArrayList<INaviView>(localCachedViews);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return 0 == column || 1 == column;
    }

    @Override
    public void setFilter(IFilter<INaviView> filter) {
        this.m_cachedViews = null;
        super.setFilter(filter);
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        INaviView view = this.getViews().get(row);
        if (column == 0) {
            try {
                view.getConfiguration().setName((String)value);
                this.fireTableDataChanged();
            }
            catch (Exception e2) {
                CUtilityFunctions.logException(e2);
                String innerMessage = "E00187: View name could not be changed";
                String innerDescription = CUtilityFunctions.createDescription(String.format("The view name of view '%s' could not be changed.", view.getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The view was not updated and the new view name is lost."});
                NaviErrorDialog.show(null, "E00187: View name could not be changed", innerDescription, e2);
            }
        } else if (column == 1) {
            try {
                view.getConfiguration().setDescription((String)value);
                this.fireTableDataChanged();
            }
            catch (Exception e3) {
                CUtilityFunctions.logException(e3);
                String innerMessage = "E00186: View description could not be changed";
                String innerDescription = CUtilityFunctions.createDescription(String.format("The view description of view '%s' could not be changed.", view.getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The view was not updated and the new view description is lost."});
                NaviErrorDialog.show(null, "E00186: View description could not be changed", innerDescription, e3);
            }
        }
    }

    private class CViewTableListener {
        private final InternalContainerListener m_containerListener = new InternalContainerListener();
        private final InternalViewListener m_viewListener = new InternalViewListener();

        public CViewTableListener() {
            CUserViewsModel.this.m_originContainer.addListener(this.m_containerListener);
        }

        public void dispose() {
            CUserViewsModel.this.m_originContainer.removeListener(this.m_containerListener);
        }

        private class InternalViewListener
        extends CViewListenerAdapter {
            private final Timer m_updateTimer = new Timer(100, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    CUserViewsModel.this.fireTableDataChanged();
                    InternalViewListener.this.m_updateTimer.stop();
                }
            });

            private InternalViewListener() {
            }

            @Override
            public void addedEdge(INaviView view, INaviEdge node) {
                CUserViewsModel.this.m_cachedViews = null;
                this.m_updateTimer.restart();
            }

            @Override
            public void addedNode(INaviView view, INaviViewNode node) {
                CUserViewsModel.this.m_cachedViews = null;
                CUserViewsModel.this.fireTableDataChanged();
            }

            @Override
            public void changedDescription(INaviView view, String description) {
                CUserViewsModel.this.m_cachedViews = null;
                CUserViewsModel.this.fireTableDataChanged();
            }

            @Override
            public void changedGraphType(INaviView view, GraphType type, GraphType oldType) {
                CUserViewsModel.this.m_cachedViews = null;
                CUserViewsModel.this.fireTableDataChanged();
            }

            @Override
            public void changedModificationDate(INaviView view, Date modificationDate) {
                CUserViewsModel.this.m_cachedViews = null;
                CUserViewsModel.this.fireTableDataChanged();
            }

            @Override
            public void changedName(INaviView view, String name) {
                CUserViewsModel.this.m_cachedViews = null;
                CUserViewsModel.this.fireTableDataChanged();
            }

            @Override
            public void changedStarState(INaviView view, boolean isStared) {
                CUserViewsModel.this.m_cachedViews = null;
                this.m_updateTimer.restart();
            }

            @Override
            public void closedView(INaviView view, IDirectedGraph<INaviViewNode, INaviEdge> oldGraph) {
                CUserViewsModel.this.m_cachedViews = null;
                CUserViewsModel.this.fireTableDataChanged();
            }

            @Override
            public void deletedEdge(INaviView view, INaviEdge edge) {
                CUserViewsModel.this.m_cachedViews = null;
                CUserViewsModel.this.fireTableDataChanged();
            }

            @Override
            public void deletedNode(INaviView view, INaviViewNode node) {
                CUserViewsModel.this.m_cachedViews = null;
                CUserViewsModel.this.fireTableDataChanged();
            }

            @Override
            public void deletedNodes(INaviView view, Collection<INaviViewNode> nodes) {
                CUserViewsModel.this.m_cachedViews = null;
                CUserViewsModel.this.fireTableDataChanged();
            }

            @Override
            public void savedView(INaviView view) {
                CUserViewsModel.this.m_cachedViews = null;
                CUserViewsModel.this.fireTableDataChanged();
            }
        }

        private class InternalContainerListener
        implements IViewContainerListener {
            private InternalContainerListener() {
            }

            @Override
            public void addedView(IViewContainer container, INaviView view) {
                CUserViewsModel.this.m_cachedViews = null;
                view.addListener(CViewTableListener.this.m_viewListener);
                CUserViewsModel.this.fireTableDataChanged();
            }

            @Override
            public void closedContainer(IViewContainer container, List<INaviView> views) {
                CUserViewsModel.this.m_cachedViews = null;
            }

            @Override
            public void deletedView(IViewContainer container, INaviView view) {
                CUserViewsModel.this.m_cachedViews = null;
                view.removeListener(CViewTableListener.this.m_viewListener);
                CUserViewsModel.this.fireTableDataChanged();
            }

            @Override
            public void loaded(IViewContainer container) {
                CUserViewsModel.this.m_cachedViews = null;
                for (INaviView view : container.getViews()) {
                    view.addListener(CViewTableListener.this.m_viewListener);
                }
            }
        }
    }
}

