/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Views.Component;

import com.google.security.zynamics.binnavi.Exceptions.MaybeNullException;
import com.google.security.zynamics.binnavi.ZyGraph.Builders.GraphBuilderEvents;
import com.google.security.zynamics.binnavi.ZyGraph.Builders.ZyGraphBuilderManager;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.disassembly.views.ViewLoadEvents;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.Builders.ZyGraphBuilder;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;

public final class CLoadProgressPainter {
    private CLoadProgressPainter() {
    }

    private static double getLoadPercentage(INaviView view) {
        int totalSteps = ViewLoadEvents.values().length + GraphBuilderEvents.values().length;
        int loadState = view.getLoadState();
        if (loadState == -1) {
            try {
                ZyGraphBuilder builder = ZyGraphBuilderManager.instance().getBuilder(view);
                return 1.0 * (double)(ViewLoadEvents.values().length + builder.getBuildStep()) / (double)totalSteps;
            }
            catch (MaybeNullException exception) {
                return 0.0;
            }
        }
        return 1.0 * (double)view.getLoadState() / (double)totalSteps;
    }

    public static void paint(INaviView view, Graphics graphics, int width, int height, Color background) {
        graphics.setColor(background);
        graphics.fillRect(0, 0, width, height);
        GradientPaint paint = new GradientPaint(0.0f, 0.0f, Color.WHITE, width, height, new Color(0, 128, 0));
        ((Graphics2D)graphics).setPaint(paint);
        graphics.fillRect(0, 0, (int)(CLoadProgressPainter.getLoadPercentage(view) * (double)width), height);
    }
}

