/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Views.Component.Actions;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphWindow;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.IGraphPanel;
import com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations.CShowViewFunctions;
import com.google.security.zynamics.binnavi.Gui.WindowManager.CWindowManager;
import com.google.security.zynamics.binnavi.ZyGraph.Implementations.ZyZoomHelpers;
import com.google.security.zynamics.binnavi.ZyGraph.Painters.CrossReferencePainter;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.types.TypeInstanceReference;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainer;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.AbstractZyGraph;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;

public class OpenInLastWindowAndZoomToAddressAction
extends AbstractAction {
    private static final long serialVersionUID = -7167187997929184030L;
    private final Window m_parent;
    private final IViewContainer m_container;
    private final INaviView[] m_views;
    private final TypeInstanceReference reference;

    public OpenInLastWindowAndZoomToAddressAction(Window parent, IViewContainer container, INaviView[] views, TypeInstanceReference reference) {
        super("Open in last window and zoom to address");
        this.m_parent = Preconditions.checkNotNull(parent, "IE02876: parent argument can not be null");
        this.m_container = Preconditions.checkNotNull(container, "IE02877: container argument can not be null");
        this.m_views = (INaviView[])Preconditions.checkNotNull(views, "IE02878: views argument can not be null").clone();
        this.reference = reference;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        FutureCallback<Boolean> callBack = new FutureCallback<Boolean>(){

            @Override
            public void onFailure(Throwable t2) {
                CUtilityFunctions.logException(t2);
            }

            @Override
            public void onSuccess(Boolean result) {
                AbstractZyGraph graph = null;
                List<CGraphWindow> windows = CWindowManager.instance().getOpenWindows();
                for (CGraphWindow graphContainer : windows) {
                    for (IGraphPanel window : graphContainer) {
                        if (!OpenInLastWindowAndZoomToAddressAction.this.reference.getView().equals(window.getModel().getGraph().getRawView())) continue;
                        graph = window.getModel().getGraph();
                    }
                }
                for (NaviNode node : graph.getNodes()) {
                    if (!(node.getRawNode() instanceof INaviCodeNode)) continue;
                    INaviCodeNode codeNode = (INaviCodeNode)node.getRawNode();
                    for (INaviInstruction instruction : codeNode.getInstructions()) {
                        if (!instruction.getAddress().equals(OpenInLastWindowAndZoomToAddressAction.this.reference.getAddress())) continue;
                        ZyZoomHelpers.zoomToAddress((ZyGraph)graph, OpenInLastWindowAndZoomToAddressAction.this.reference.getAddress());
                        CrossReferencePainter.paintCrossReference(node, codeNode, OpenInLastWindowAndZoomToAddressAction.this.reference, instruction);
                    }
                }
            }
        };
        CShowViewFunctions.showViewsAndPerformCallBack(this.m_parent, this.m_container, this.m_views, CWindowManager.instance().getLastWindow(), callBack);
    }
}

