/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Views;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.CTablePanel;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Views.Component.CUserViewsTable;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Views.Help.CViewFilterHelp;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.filters.CViewFilterCreator;
import com.google.security.zynamics.binnavi.disassembly.views.CViewListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainer;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainerListener;
import com.google.security.zynamics.zylib.disassembly.GraphType;
import java.util.List;
import javax.swing.JTree;

public final class CUserViewsComponent
extends CTablePanel<INaviView> {
    private static final long serialVersionUID = -781341538571122763L;
    private final IViewContainer container;
    private final InternalContainerListener m_containerListener = new InternalContainerListener();
    private final InternalViewListener m_viewListener = new InternalViewListener();

    public CUserViewsComponent(JTree projectTree, IViewContainer container) {
        super(new CUserViewsTable(projectTree, container, container), new CViewFilterCreator(container), new CViewFilterHelp());
        Preconditions.checkNotNull(projectTree, "IE02013: Project tree argument can not be null");
        Preconditions.checkNotNull(container, "IE02014: Original container argument can not be null");
        this.container = container;
        container.addListener(this.m_containerListener);
        if (container.isLoaded()) {
            for (INaviView view : container.getViews()) {
                view.addListener(this.m_viewListener);
            }
        }
        this.updateBorderText(this.getBorderText());
    }

    private String getBorderText() {
        return String.format("%d Views", this.container.getViewCount());
    }

    @Override
    protected void disposeInternal() {
        this.container.removeListener(this.m_containerListener);
        if (this.container.isLoaded()) {
            for (INaviView view : this.container.getViews()) {
                view.removeListener(this.m_viewListener);
            }
        }
    }

    private class InternalViewListener
    extends CViewListenerAdapter {
        private InternalViewListener() {
        }

        @Override
        public void changedGraphType(INaviView view, GraphType type, GraphType oldType) {
            CUserViewsComponent.this.updateBorderText(CUserViewsComponent.this.getBorderText());
        }
    }

    private class InternalContainerListener
    implements IViewContainerListener {
        private InternalContainerListener() {
        }

        @Override
        public void addedView(IViewContainer container, INaviView view) {
            CUserViewsComponent.this.updateBorderText(CUserViewsComponent.this.getBorderText());
            view.addListener(CUserViewsComponent.this.m_viewListener);
        }

        @Override
        public void closedContainer(IViewContainer moduleContainer, List<INaviView> views) {
            if (CUserViewsComponent.this.container.isLoaded()) {
                for (INaviView view : CUserViewsComponent.this.container.getViews()) {
                    view.removeListener(CUserViewsComponent.this.m_viewListener);
                }
            }
        }

        @Override
        public void deletedView(IViewContainer moduleContainer, INaviView view) {
            CUserViewsComponent.this.updateBorderText(CUserViewsComponent.this.getBorderText());
            view.removeListener(CUserViewsComponent.this.m_viewListener);
        }

        @Override
        public void loaded(IViewContainer container) {
            for (INaviView view : container.getViews()) {
                view.addListener(CUserViewsComponent.this.m_viewListener);
            }
            CUserViewsComponent.this.updateBorderText(CUserViewsComponent.this.getBorderText());
        }
    }
}

