/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Traces.Component;

import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractTreeViewsTableModel;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.zylib.disassembly.ViewType;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.general.comparators.IntComparator;
import com.google.security.zynamics.zylib.types.lists.FilledList;
import com.google.security.zynamics.zylib.types.lists.IFilledList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public final class CArbitraryViewsModel
extends CAbstractTreeViewsTableModel {
    private static final long serialVersionUID = 7352980312308189539L;
    private static final String[] COLUMN_NAMES = new String[]{"Type", "Name", "Description", "Nodes", "Edges", "Creation Date", "Modification Date"};
    private static final int TYPE_COLUMN = 0;
    private static final int NAME_COLUMN = 1;
    private static final int DESCRIPTION_COLUMN = 2;
    private static final int NODE_COUNT_COLUMN = 3;
    private static final int EDGE_COUNT_COLUMN = 4;
    private static final int CREATION_DATE_COLUMN = 5;
    private static final int MODIFICATION_DATE_COLUMN = 6;
    private final IFilledList<INaviView> m_views = new FilledList<INaviView>();

    @Override
    public void delete() {
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    @Override
    public int getRowCount() {
        return this.m_views.size();
    }

    @Override
    public List<Pair<Integer, Comparator<?>>> getSorters() {
        ArrayList sorters = new ArrayList();
        sorters.add(new Pair<Integer, IntComparator>(3, new IntComparator()));
        sorters.add(new Pair<Integer, IntComparator>(4, new IntComparator()));
        return sorters;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        INaviView view = (INaviView)this.m_views.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return view.getType() == ViewType.Native ? "Native" : "Not Native";
            }
            case 1: {
                return view.getName();
            }
            case 2: {
                return view.getConfiguration().getDescription();
            }
            case 3: {
                return view.getNodeCount();
            }
            case 4: {
                return view.getEdgeCount();
            }
            case 5: {
                return view.getConfiguration().getCreationDate();
            }
            case 6: {
                return view.getConfiguration().getModificationDate();
            }
        }
        throw new IllegalStateException("IE02242: Unknown column");
    }

    @Override
    public List<INaviView> getViews() {
        return this.m_views;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return 1 == column || 2 == column;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        INaviView view = this.getViews().get(row);
        if (column == 1) {
            try {
                view.getConfiguration().setName((String)value);
                this.fireTableDataChanged();
            }
            catch (Exception e2) {
                CUtilityFunctions.logException(e2);
                String innerMessage = "E00184: View name could not be changed";
                String innerDescription = CUtilityFunctions.createDescription(String.format("The view name of view '%s' could not be changed.", view.getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The view was not updated and the new view name is lost."});
                NaviErrorDialog.show(null, "E00184: View name could not be changed", innerDescription, e2);
            }
        } else if (column == 2) {
            try {
                view.getConfiguration().setDescription((String)value);
                this.fireTableDataChanged();
            }
            catch (Exception e3) {
                CUtilityFunctions.logException(e3);
                String innerMessage = "E00185: View description could not be changed";
                String innerDescription = CUtilityFunctions.createDescription(String.format("The view description of view '%s' could not be changed.", view.getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The view was not updated and the new view description is lost."});
                NaviErrorDialog.show(null, "E00185: View description could not be changed", innerDescription, e3);
            }
        }
    }

    public void setViews(List<INaviView> views) {
        this.m_views.clear();
        this.m_views.addAll(views);
        this.fireTableDataChanged();
    }
}

