/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.TagContainer;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CMain;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractLazyComponent;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractNodeComponent;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CProjectTreeNode;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Tag.CTagNode;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.TagContainer.CTagContainerNodeMenuBuilder;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.TagContainer.Component.CTagContainerNodeComponent;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.Tagging.CTagManager;
import com.google.security.zynamics.binnavi.Tagging.ITagManagerListener;
import com.google.security.zynamics.binnavi.Tagging.TagComparator;
import com.google.security.zynamics.zylib.types.trees.ITreeNode;
import com.google.security.zynamics.zylib.types.trees.TreeNode;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;

public final class CTagContainerNode
extends CProjectTreeNode<Object> {
    private static final long serialVersionUID = 4190505746650765116L;
    private static final ImageIcon ICON_DEBUGGER_CONTAINER = new ImageIcon(CMain.class.getResource("data/projecttreeicons/tag_container.png"));
    private final IDatabase m_database;
    private final ITreeNode<CTag> m_rootTag;
    private final InternalTagManagerListener m_tagManagerListener = new InternalTagManagerListener();

    public CTagContainerNode(final JTree projectTree, final IDatabase database) {
        super(projectTree, new CAbstractLazyComponent(){

            @Override
            protected CAbstractNodeComponent createComponent() {
                return new CTagContainerNodeComponent(projectTree, database);
            }
        }, new CTagContainerNodeMenuBuilder(projectTree, database), 0);
        Preconditions.checkNotNull(database, "IE02002: Database can't be null");
        this.m_database = database;
        this.m_rootTag = this.m_database.getContent().getViewTagManager().getRootTag();
        this.m_database.getContent().getViewTagManager().addListener(this.m_tagManagerListener);
        this.createChildren();
    }

    @Override
    protected void createChildren() {
        if (this.m_database.isLoaded()) {
            List<ITreeNode<CTag>> children = this.m_rootTag.getChildren();
            Collections.sort(children, new TagComparator());
            for (ITreeNode<CTag> tag : children) {
                this.add(new CTagNode(this.getProjectTree(), this.m_database, (TreeNode)tag));
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.m_database.getContent().getViewTagManager().removeListener(this.m_tagManagerListener);
        this.deleteChildren();
    }

    @Override
    public void doubleClicked() {
    }

    @Override
    public Icon getIcon() {
        return ICON_DEBUGGER_CONTAINER;
    }

    @Override
    public String toString() {
        String string2 = String.valueOf("View Tags (");
        int n2 = this.m_rootTag.getChildren().size();
        return new StringBuilder(12 + String.valueOf(string2).length()).append(string2).append(n2).append(")").toString();
    }

    private class InternalTagManagerListener
    implements ITagManagerListener {
        private InternalTagManagerListener() {
        }

        private boolean hasChild(ITreeNode<CTag> tag) {
            for (int i2 = 0; i2 < CTagContainerNode.this.getChildCount(); ++i2) {
                CTagNode node = (CTagNode)CTagContainerNode.this.getChildAt(i2);
                if (((TreeNode)node.getObject()).getObject() != tag.getObject()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void addedTag(CTagManager manager, ITreeNode<CTag> tag) {
            if (tag.getParent() == CTagContainerNode.this.m_rootTag) {
                CTagContainerNode.this.add(new CTagNode(CTagContainerNode.this.getProjectTree(), CTagContainerNode.this.m_database, (TreeNode)tag));
                CTagContainerNode.this.getTreeModel().nodeStructureChanged(CTagContainerNode.this);
            }
        }

        @Override
        public void deletedTag(CTagManager manager, ITreeNode<CTag> parent, ITreeNode<CTag> tag) {
            if (this.hasChild(tag)) {
                HashSet<CTagNode> toDelete = new HashSet<CTagNode>();
                for (int i2 = 0; i2 < CTagContainerNode.this.getChildCount(); ++i2) {
                    CTagNode node = (CTagNode)CTagContainerNode.this.getChildAt(i2);
                    toDelete.add(node);
                }
                for (CTagNode node : toDelete) {
                    node.dispose();
                    CTagContainerNode.this.remove(node);
                }
                CTagContainerNode.this.createChildren();
                CTagContainerNode.this.getTreeModel().nodeStructureChanged(CTagContainerNode.this);
            }
        }

        @Override
        public void deletedTagSubtree(CTagManager manager, ITreeNode<CTag> parent, ITreeNode<CTag> tag) {
            if (this.hasChild(tag)) {
                for (int i2 = 0; i2 < CTagContainerNode.this.getChildCount(); ++i2) {
                    CTagNode node = (CTagNode)CTagContainerNode.this.getChildAt(i2);
                    if (node.getObject() != tag) continue;
                    node.dispose();
                    CTagContainerNode.this.remove(node);
                    break;
                }
                CTagContainerNode.this.getTreeModel().nodeStructureChanged(CTagContainerNode.this);
            }
        }

        @Override
        public void insertedTag(CTagManager tagManager, ITreeNode<CTag> parent, ITreeNode<CTag> tag) {
        }
    }
}

