/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Tag.Component;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractNodeComponent;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Tag.Component.CChildTagsTable;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Tag.Component.Help.CDescriptionHelp;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Tag.Component.Help.CNameHelp;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Tag.Component.Help.CSaveHelp;
import com.google.security.zynamics.binnavi.Gui.SaveFields.CSaveField;
import com.google.security.zynamics.binnavi.Gui.SaveFields.CSavePane;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.Help.CHelpButton;
import com.google.security.zynamics.binnavi.Help.CHelpLabel;
import com.google.security.zynamics.binnavi.Help.CHelpSaveField;
import com.google.security.zynamics.binnavi.Help.CHelpSavePane;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.Tagging.CTagManager;
import com.google.security.zynamics.binnavi.Tagging.ITagListener;
import com.google.security.zynamics.binnavi.Tagging.ITagManagerListener;
import com.google.security.zynamics.zylib.types.trees.ITreeNode;
import com.google.security.zynamics.zylib.types.trees.TreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public final class CTagNodeComponent
extends CAbstractNodeComponent {
    private static final long serialVersionUID = -6040807788139421729L;
    private final IDatabase m_database;
    private final TreeNode<CTag> m_tagTreeNode;
    private final CSaveField m_nameTextField;
    private final CSavePane m_descriptionField;
    private final CChildTagsTable m_childrenTagTable;
    private final TitledBorder m_tableBorder;
    private final JButton m_saveButton = new CHelpButton(CActionProxy.proxy(new SaveAction()), new CSaveHelp());
    private final InternalTagManagerListener m_tagManagerListener = new InternalTagManagerListener();
    private final InternalTagListener m_tagListener = new InternalTagListener();

    public CTagNodeComponent(JTree projectTree, IDatabase database, TreeNode<CTag> tagTreeNode) {
        super(new BorderLayout());
        Preconditions.checkNotNull(projectTree, "IE02000: Project tree argument can not be null");
        Preconditions.checkNotNull(tagTreeNode, "IE02001: Tree node argument can not be null");
        this.m_database = database;
        this.m_tagTreeNode = tagTreeNode;
        this.m_nameTextField = new CHelpSaveField(tagTreeNode.getObject().getName(), new CNameHelp());
        this.m_descriptionField = new CHelpSavePane(tagTreeNode.getObject().getDescription(), new CDescriptionHelp());
        this.m_childrenTagTable = new CChildTagsTable(projectTree, this.m_tagTreeNode, database);
        this.m_tableBorder = new TitledBorder(this.getBorderText());
        this.createGui();
        this.m_database.getContent().getViewTagManager().addListener(this.m_tagManagerListener);
        this.m_tagTreeNode.getObject().addListener(this.m_tagListener);
        UpdateListener updateListener = new UpdateListener();
        this.m_nameTextField.getDocument().addDocumentListener(updateListener);
        this.m_descriptionField.getDocument().addDocumentListener(updateListener);
        this.updateGUI();
    }

    private void createGui() {
        JPanel outerNamePanel = new JPanel(new BorderLayout());
        outerNamePanel.setBorder(new TitledBorder("Tag"));
        JPanel namePanel = new JPanel(new BorderLayout());
        namePanel.setBorder(new EmptyBorder(0, 0, 5, 0));
        CHelpLabel nameLabel = new CHelpLabel("Name:", new CNameHelp());
        nameLabel.setPreferredSize(new Dimension(110, 25));
        namePanel.add((Component)nameLabel, "West");
        namePanel.add((Component)this.m_nameTextField, "Center");
        outerNamePanel.add((Component)namePanel, "Center");
        JPanel outerDescriptionPanel = new JPanel(new BorderLayout());
        outerDescriptionPanel.setBorder(new EmptyBorder(5, 0, 0, 0));
        JPanel descriptionPanel = new JPanel(new BorderLayout());
        descriptionPanel.setBorder(new TitledBorder("Description"));
        descriptionPanel.setMinimumSize(new Dimension(0, 120));
        descriptionPanel.add(new JScrollPane(this.m_descriptionField));
        outerDescriptionPanel.add((Component)descriptionPanel, "Center");
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2));
        buttonPanel.add(new JPanel());
        buttonPanel.setBorder(new EmptyBorder(5, 0, 5, 2));
        buttonPanel.add(this.m_saveButton);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)outerNamePanel, "North");
        topPanel.add((Component)outerDescriptionPanel, "Center");
        topPanel.add((Component)buttonPanel, "South");
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.setBorder(this.m_tableBorder);
        JScrollPane scrollPane = new JScrollPane(this.m_childrenTagTable);
        bottomPanel.add((Component)scrollPane, "Center");
        JSplitPane splitPane = new JSplitPane(0, true, topPanel, bottomPanel);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(splitPane.getMinimumDividerLocation());
        splitPane.setResizeWeight(0.5);
        this.add(splitPane);
    }

    private String getBorderText() {
        return String.format("%d %s", this.m_tagTreeNode.getChildren().size(), "Child Tags");
    }

    private void save() {
        String innerDescription;
        String innerMessage;
        try {
            this.m_tagTreeNode.getObject().setName(this.m_nameTextField.getText());
        }
        catch (CouldntSaveDataException e2) {
            CUtilityFunctions.logException(e2);
            innerMessage = "E00182: Could not change tag name";
            innerDescription = CUtilityFunctions.createDescription(String.format("The name of the tag '%s' could not be changed.", this.m_tagTreeNode.getObject().getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The tag name could not be changed."});
            NaviErrorDialog.show(SwingUtilities.getWindowAncestor(this), "E00182: Could not change tag name", innerDescription, e2);
        }
        try {
            this.m_tagTreeNode.getObject().setDescription(this.m_descriptionField.getText());
        }
        catch (CouldntSaveDataException e3) {
            CUtilityFunctions.logException(e3);
            innerMessage = "E00183: Could not change tag description";
            innerDescription = CUtilityFunctions.createDescription(String.format("The description of the tag '%s' could not be changed.", this.m_tagTreeNode.getObject().getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The tag description could not be changed."});
            NaviErrorDialog.show(SwingUtilities.getWindowAncestor(this), "E00183: Could not change tag description", innerDescription, e3);
        }
    }

    private void updateGUI() {
        boolean textChanged = !this.m_nameTextField.getText().equals(this.m_tagTreeNode.getObject().getName());
        boolean descriptionChanged = !this.m_descriptionField.getText().equals(this.m_tagTreeNode.getObject().getDescription());
        this.m_saveButton.setEnabled(textChanged || descriptionChanged);
        this.m_nameTextField.setModified(textChanged);
        this.m_descriptionField.setModified(descriptionChanged);
    }

    @Override
    public void dispose() {
        this.m_database.getContent().getViewTagManager().removeListener(this.m_tagManagerListener);
        this.m_tagTreeNode.getObject().removeListener(this.m_tagListener);
        this.m_childrenTagTable.dispose();
    }

    private class UpdateListener
    implements DocumentListener {
        private UpdateListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent event) {
            CTagNodeComponent.this.updateGUI();
        }

        @Override
        public void insertUpdate(DocumentEvent event) {
            CTagNodeComponent.this.updateGUI();
        }

        @Override
        public void removeUpdate(DocumentEvent event) {
            CTagNodeComponent.this.updateGUI();
        }
    }

    private class SaveAction
    extends AbstractAction {
        private static final long serialVersionUID = -2385339704599606246L;

        private SaveAction() {
            super("Save");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CTagNodeComponent.this.save();
        }
    }

    private class InternalTagManagerListener
    implements ITagManagerListener {
        private InternalTagManagerListener() {
        }

        private void updateBorder() {
            CTagNodeComponent.this.m_tableBorder.setTitle(CTagNodeComponent.this.getBorderText());
            CTagNodeComponent.this.updateUI();
        }

        @Override
        public void addedTag(CTagManager manager, ITreeNode<CTag> tag) {
            this.updateBorder();
        }

        @Override
        public void deletedTag(CTagManager manager, ITreeNode<CTag> parent, ITreeNode<CTag> tag) {
            this.updateBorder();
        }

        @Override
        public void deletedTagSubtree(CTagManager manager, ITreeNode<CTag> parent, ITreeNode<CTag> tag) {
            this.updateBorder();
        }

        @Override
        public void insertedTag(CTagManager tagManager, ITreeNode<CTag> parent, ITreeNode<CTag> tag) {
            this.updateBorder();
        }
    }

    private class InternalTagListener
    implements ITagListener {
        private InternalTagListener() {
        }

        @Override
        public void changedDescription(CTag tag, String description) {
            CTagNodeComponent.this.m_descriptionField.setText(tag.getDescription());
            CTagNodeComponent.this.updateGUI();
        }

        @Override
        public void changedName(CTag tag, String name) {
            CTagNodeComponent.this.m_nameTextField.setText(tag.getName());
            CTagNodeComponent.this.updateGUI();
        }

        @Override
        public void deletedTag(CTag tag) {
        }
    }
}

