/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Tag.Component;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractTreeTableModel;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.Tagging.CTagManager;
import com.google.security.zynamics.binnavi.Tagging.ITagListener;
import com.google.security.zynamics.binnavi.Tagging.ITagManagerListener;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.general.comparators.IntComparator;
import com.google.security.zynamics.zylib.types.trees.ITreeNode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public final class CChildTagsModel
extends CAbstractTreeTableModel<CTag> {
    private static final long serialVersionUID = -5680955818776214499L;
    private static final int NAME_COLUMN = 0;
    private static final int DESCRIPTION_COLUMN = 1;
    private static final int CHILDREN_COUNT_COLUMN = 2;
    private final String[] COLUMNS = new String[]{"Name", "Description", "Children"};
    private final IDatabase m_database;
    private final ITreeNode<CTag> m_tagTreeNode;
    private final InternalTagManagerListener m_tagManagerListener = new InternalTagManagerListener();
    private final InternalTagListener m_tagListener = new InternalTagListener();

    public CChildTagsModel(IDatabase database, ITreeNode<CTag> tagTreeNode) {
        this.m_tagTreeNode = Preconditions.checkNotNull(tagTreeNode, "IE01996: Tag argument can't be null");
        this.m_database = Preconditions.checkNotNull(database, "IE01997: Database argument can't be null");
        this.m_database.getContent().getViewTagManager().addListener(this.m_tagManagerListener);
        this.m_tagTreeNode.getObject().addListener(this.m_tagListener);
    }

    @Override
    public void delete() {
        this.m_database.getContent().getViewTagManager().removeListener(this.m_tagManagerListener);
        this.m_tagTreeNode.getObject().removeListener(this.m_tagListener);
    }

    @Override
    public int getColumnCount() {
        return this.COLUMNS.length;
    }

    @Override
    public String getColumnName(int index) {
        return this.COLUMNS[index];
    }

    @Override
    public int getRowCount() {
        return this.m_tagTreeNode.getChildren().size();
    }

    @Override
    public List<Pair<Integer, Comparator<?>>> getSorters() {
        ArrayList sorters = new ArrayList();
        sorters.add(new Pair<Integer, IntComparator>(2, new IntComparator()));
        return sorters;
    }

    @Override
    public Object getValueAt(int row, int col) {
        List<ITreeNode<CTag>> children = this.m_tagTreeNode.getChildren();
        ITreeNode<CTag> tagNode = children.get(row);
        switch (col) {
            case 0: {
                return tagNode.getObject().getName();
            }
            case 1: {
                return tagNode.getObject().getDescription();
            }
            case 2: {
                return tagNode.getChildren().size();
            }
        }
        throw new IllegalStateException("IE01178: Invalid column");
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 0 || col == 1;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col != 0 && col != 1) {
            throw new IllegalStateException("IE01179: Column can not be edited");
        }
        List<ITreeNode<CTag>> children = this.m_tagTreeNode.getChildren();
        ITreeNode<CTag> tagNode = children.get(row);
        if (col == 0) {
            try {
                tagNode.getObject().setName((String)value);
            }
            catch (CouldntSaveDataException e2) {
                CUtilityFunctions.logException(e2);
                String innerMessage = "E00180: Could not change tag name";
                String innerDescription = CUtilityFunctions.createDescription(String.format("The name of the tag '%s' could not be changed.", tagNode.getObject().getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The tag name could not be changed."});
                NaviErrorDialog.show(null, "E00180: Could not change tag name", innerDescription, e2);
            }
        } else if (col == 1) {
            try {
                tagNode.getObject().setDescription((String)value);
            }
            catch (CouldntSaveDataException e3) {
                CUtilityFunctions.logException(e3);
                String innerMessage = "E00181: Could not change tag description";
                String innerDescription = CUtilityFunctions.createDescription(String.format("The description of the tag '%s' could not be changed.", tagNode.getObject().getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The tag description could not be changed."});
                NaviErrorDialog.show(null, "E00181: Could not change tag description", innerDescription, e3);
            }
        }
    }

    private class InternalTagManagerListener
    implements ITagManagerListener {
        private InternalTagManagerListener() {
        }

        @Override
        public void addedTag(CTagManager manager, ITreeNode<CTag> tag) {
            CChildTagsModel.this.fireTableDataChanged();
        }

        @Override
        public void deletedTag(CTagManager manager, ITreeNode<CTag> parent, ITreeNode<CTag> tag) {
            CChildTagsModel.this.fireTableDataChanged();
        }

        @Override
        public void deletedTagSubtree(CTagManager manager, ITreeNode<CTag> parent, ITreeNode<CTag> tag) {
            CChildTagsModel.this.fireTableDataChanged();
        }

        @Override
        public void insertedTag(CTagManager tagManager, ITreeNode<CTag> parent, ITreeNode<CTag> tag) {
            CChildTagsModel.this.fireTableDataChanged();
        }
    }

    private class InternalTagListener
    implements ITagListener {
        private InternalTagListener() {
        }

        @Override
        public void changedDescription(CTag tag, String description) {
            CChildTagsModel.this.fireTableDataChanged();
        }

        @Override
        public void changedName(CTag tag, String name) {
            CChildTagsModel.this.fireTableDataChanged();
        }

        @Override
        public void deletedTag(CTag tag) {
            CChildTagsModel.this.fireTableDataChanged();
        }
    }
}

