/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Tag;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CMain;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractLazyComponent;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractNodeComponent;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CProjectTreeNode;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Tag.CTagNodeMenuBuilder;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Tag.Component.CTagNodeComponent;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.Tagging.CTagManager;
import com.google.security.zynamics.binnavi.Tagging.ITagListener;
import com.google.security.zynamics.binnavi.Tagging.ITagManager;
import com.google.security.zynamics.binnavi.Tagging.ITagManagerListener;
import com.google.security.zynamics.binnavi.Tagging.TagComparator;
import com.google.security.zynamics.zylib.types.trees.ITreeNode;
import com.google.security.zynamics.zylib.types.trees.TreeNode;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;

public final class CTagNode
extends CProjectTreeNode<TreeNode<CTag>> {
    private static final long serialVersionUID = -8765870129366710327L;
    private static final ImageIcon ICON_TAG = new ImageIcon(CMain.class.getResource("data/projecttreeicons/tag.png"));
    private final IDatabase m_database;
    private final TreeNode<CTag> m_tag;
    private final InternalTagManagerListener m_tagManagerListener = new InternalTagManagerListener();
    private final InternalTagListener m_tagListener = new InternalTagListener();

    public CTagNode(final JTree projectTree, final IDatabase database, final TreeNode<CTag> tag) {
        super(projectTree, new CAbstractLazyComponent(){

            @Override
            protected CAbstractNodeComponent createComponent() {
                return new CTagNodeComponent(projectTree, database, tag);
            }
        }, new CTagNodeMenuBuilder(projectTree, database, tag), tag);
        this.m_database = Preconditions.checkNotNull(database, "IE01998: Database argument can NOT be null");
        this.m_tag = Preconditions.checkNotNull(tag, "IE02347: Tag argument can not be null");
        this.m_database.getContent().getViewTagManager().addListener(this.m_tagManagerListener);
        this.m_tag.getObject().addListener(this.m_tagListener);
        this.createChildren();
    }

    @Override
    protected void createChildren() {
        if (this.m_database.isLoaded()) {
            List<ITreeNode<CTag>> children = this.m_tag.getChildren();
            Collections.sort(children, new TagComparator());
            for (ITreeNode<CTag> tag : children) {
                this.add(new CTagNode(this.getProjectTree(), this.m_database, (TreeNode)tag));
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.m_database.getContent().getViewTagManager().removeListener(this.m_tagManagerListener);
        this.m_tag.getObject().removeListener(this.m_tagListener);
        this.deleteChildren();
    }

    @Override
    public void doubleClicked() {
    }

    @Override
    public Icon getIcon() {
        return ICON_TAG;
    }

    public ITagManager getTagManager() {
        return this.m_database.getContent().getViewTagManager();
    }

    @Override
    public String toString() {
        String string2 = this.m_tag.getObject().getName();
        int n2 = this.m_tag.getChildren().size();
        return new StringBuilder(14 + String.valueOf(string2).length()).append(string2).append(" (").append(n2).append(")").toString();
    }

    private class InternalTagManagerListener
    implements ITagManagerListener {
        private InternalTagManagerListener() {
        }

        private boolean hasChild(ITreeNode<CTag> tag) {
            for (int i2 = 0; i2 < CTagNode.this.getChildCount(); ++i2) {
                CTagNode node = (CTagNode)CTagNode.this.getChildAt(i2);
                if (((TreeNode)node.getObject()).getObject() != tag.getObject()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void addedTag(CTagManager manager, ITreeNode<CTag> tag) {
            if (tag.getParent() == CTagNode.this.m_tag) {
                CTagNode.this.add(new CTagNode(CTagNode.this.getProjectTree(), CTagNode.this.m_database, (TreeNode)tag));
                CTagNode.this.getTreeModel().nodeStructureChanged(CTagNode.this);
            }
        }

        @Override
        public void deletedTag(CTagManager manager, ITreeNode<CTag> parent, ITreeNode<CTag> tag) {
            if (this.hasChild(tag)) {
                HashSet<CTagNode> toDelete = new HashSet<CTagNode>();
                for (int i2 = 0; i2 < CTagNode.this.getChildCount(); ++i2) {
                    CTagNode node = (CTagNode)CTagNode.this.getChildAt(i2);
                    toDelete.add(node);
                }
                for (CTagNode node : toDelete) {
                    node.dispose();
                    CTagNode.this.remove(node);
                }
                CTagNode.this.createChildren();
                CTagNode.this.getTreeModel().nodeStructureChanged(CTagNode.this);
            }
        }

        @Override
        public void deletedTagSubtree(CTagManager manager, ITreeNode<CTag> parent, ITreeNode<CTag> tag) {
            if (this.hasChild(tag)) {
                for (int i2 = 0; i2 < CTagNode.this.getChildCount(); ++i2) {
                    CTagNode node = (CTagNode)CTagNode.this.getChildAt(i2);
                    if (node.getObject() != tag) continue;
                    node.dispose();
                    CTagNode.this.remove(node);
                    break;
                }
            }
            CTagNode.this.getTreeModel().nodeStructureChanged(CTagNode.this);
        }

        @Override
        public void insertedTag(CTagManager tagManager, ITreeNode<CTag> parent, ITreeNode<CTag> tag) {
            if (tag.getParent() == CTagNode.this.m_tag) {
                HashSet<CTagNode> toDelete = new HashSet<CTagNode>();
                for (int i2 = 0; i2 < CTagNode.this.getChildCount(); ++i2) {
                    toDelete.add((CTagNode)CTagNode.this.getChildAt(i2));
                }
                for (CTagNode node : toDelete) {
                    node.dispose();
                    CTagNode.this.remove(node);
                }
                CTagNode.this.add(new CTagNode(CTagNode.this.getProjectTree(), CTagNode.this.m_database, (TreeNode)tag));
                CTagNode.this.getTreeModel().nodeStructureChanged(CTagNode.this);
            }
        }
    }

    private class InternalTagListener
    implements ITagListener {
        private InternalTagListener() {
        }

        @Override
        public void changedDescription(CTag tag, String description) {
            CTagNode.this.getTreeModel().nodeChanged(CTagNode.this);
        }

        @Override
        public void changedName(CTag tag, String name) {
            CTagNode.this.getTreeModel().nodeChanged(CTagNode.this);
        }

        @Override
        public void deletedTag(CTag tag) {
        }
    }
}

