/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Root;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.CDatabaseManager;
import com.google.security.zynamics.binnavi.Database.Interfaces.DatabaseManagerListener;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabaseManager;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.CProjectTree;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractLazyComponent;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractNodeComponent;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CProjectTreeNode;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Database.CDatabaseNode;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Root.CRootNodeMenuBuilder;
import com.google.security.zynamics.binnavi.yfileswrap.Gui.MainWindow.ProjectTree.Nodes.Root.Component.CRootNodeComponent;

public final class CRootNode
extends CProjectTreeNode<Object> {
    private static final long serialVersionUID = 5465122680831083053L;
    private final CDatabaseManager m_databaseManager;
    private final InternalDatabaseManagerListener m_listener;

    public CRootNode(CProjectTree projectTree, CDatabaseManager databaseManager) {
        super(projectTree, new CAbstractLazyComponent(){

            @Override
            protected CAbstractNodeComponent createComponent() {
                return new CRootNodeComponent();
            }
        }, new CRootNodeMenuBuilder(projectTree));
        Preconditions.checkNotNull(databaseManager, "IE01995: Database manager can't be null");
        this.m_databaseManager = databaseManager;
        this.createChildren();
        this.m_listener = new InternalDatabaseManagerListener();
        this.m_databaseManager.addListener(this.m_listener);
    }

    @Override
    protected void createChildren() {
        for (IDatabase database : this.m_databaseManager) {
            this.add(new CDatabaseNode(this.getProjectTree(), this, database));
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.m_databaseManager.removeListener(this.m_listener);
        this.deleteChildren();
    }

    @Override
    public void doubleClicked() {
    }

    @Override
    public String toString() {
        return "BinNavi Project Tree";
    }

    private class InternalDatabaseManagerListener
    implements DatabaseManagerListener {
        private InternalDatabaseManagerListener() {
        }

        @Override
        public void addedDatabase(IDatabaseManager databaseManager, IDatabase database) {
            for (int i2 = 0; i2 < CRootNode.this.getChildCount(); ++i2) {
                CDatabaseNode child = (CDatabaseNode)CRootNode.this.getChildAt(i2);
                if (child.getObject() != database) continue;
                throw new IllegalStateException("IE01177: Database should not be added twice");
            }
            CRootNode.this.add(new CDatabaseNode(CRootNode.this.getProjectTree(), CRootNode.this, database));
            CRootNode.this.getTreeModel().nodeStructureChanged(CRootNode.this);
        }

        @Override
        public void removedDatabase(IDatabaseManager databaseManager, IDatabase database) {
            for (int i2 = 0; i2 < CRootNode.this.getChildCount(); ++i2) {
                CDatabaseNode child = (CDatabaseNode)CRootNode.this.getChildAt(i2);
                if (child.getObject() != database) continue;
                child.dispose();
                CRootNode.this.remove(child);
                CRootNode.this.getTreeModel().nodeStructureChanged(CRootNode.this);
                return;
            }
        }

        @Override
        public void reorderedDatabases(IDatabaseManager databaseManager, IDatabase database, int index) {
            CRootNode.this.deleteChildren();
            CRootNode.this.removeAllChildren();
            CRootNode.this.createChildren();
            CRootNode.this.getTreeModel().nodeStructureChanged(CRootNode.this);
        }
    }
}

