/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.ProjectContainer.Component;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.CDatabaseListenerAdapter;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.IFilter;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractTreeTableModel;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.disassembly.CProject;
import com.google.security.zynamics.binnavi.disassembly.CProjectListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.INaviProject;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public final class CProjectsModel
extends CAbstractTreeTableModel<INaviProject> {
    private static final long serialVersionUID = -6723444733980985791L;
    private static final int NAME_COLUMN = 0;
    private static final int DESCRIPTION_COLUMN = 1;
    private static final int CREATION_DATE_COLUMN = 2;
    private static final int MODIFICATION_DATE_COLUMN = 3;
    private final String[] COLUMNS = new String[]{"Name", "Description", "Creation Date", "Modification Date"};
    private final IDatabase m_database;
    private final InternalDatabaseListener m_databaseListener = new InternalDatabaseListener();
    private final InternalProjectListener m_projectListener = new InternalProjectListener();
    private List<INaviProject> m_cachedValues = null;

    public CProjectsModel(IDatabase database) {
        Preconditions.checkNotNull(database, "IE01989: Database argument can't be null");
        this.m_database = database;
        database.addListener(this.m_databaseListener);
        if (database.isLoaded()) {
            List<INaviProject> projects = database.getContent().getProjects();
            for (INaviProject project : projects) {
                project.addListener(this.m_projectListener);
            }
        }
    }

    @Override
    public void delete() {
        this.m_database.removeListener(this.m_databaseListener);
        if (this.m_database.isLoaded()) {
            List<INaviProject> projects = this.m_database.getContent().getProjects();
            for (INaviProject project : projects) {
                project.removeListener(this.m_projectListener);
            }
        }
    }

    @Override
    public int getColumnCount() {
        return this.COLUMNS.length;
    }

    @Override
    public String getColumnName(int index) {
        return this.COLUMNS[index];
    }

    public ArrayList<INaviProject> getProjects() {
        List<INaviProject> localCachedValues = this.m_cachedValues;
        if (localCachedValues == null) {
            IFilter<INaviProject> filter;
            localCachedValues = this.m_database.isConnected() ? ((filter = this.getFilter()) == null ? this.m_database.getContent().getProjects() : filter.get(this.m_database.getContent().getProjects())) : new ArrayList<INaviProject>();
        }
        this.m_cachedValues = localCachedValues;
        return new ArrayList<INaviProject>(localCachedValues);
    }

    @Override
    public int getRowCount() {
        return this.getProjects().size();
    }

    @Override
    public List<Pair<Integer, Comparator<?>>> getSorters() {
        return new ArrayList();
    }

    @Override
    public Object getValueAt(int row, int col) {
        INaviProject project = this.getProjects().get(row);
        switch (col) {
            case 0: {
                return project.getConfiguration().getName();
            }
            case 1: {
                return project.getConfiguration().getDescription();
            }
            case 2: {
                return project.getConfiguration().getCreationDate();
            }
            case 3: {
                return project.getConfiguration().getModificationDate();
            }
        }
        throw new IllegalStateException("IE01171: Invalid column");
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 0 || col == 1;
    }

    @Override
    public void setFilter(IFilter<INaviProject> filter) {
        this.m_cachedValues = null;
        super.setFilter(filter);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col != 0 && col != 1) {
            throw new IllegalStateException("IE01172: Column can not be edited");
        }
        INaviProject project = this.getProjects().get(row);
        if (col == 0) {
            try {
                project.getConfiguration().setName((String)value);
            }
            catch (CouldntSaveDataException e2) {
                CUtilityFunctions.logException(e2);
                String innerMessage = "E00174: Could not save project name";
                String innerDescription = CUtilityFunctions.createDescription(String.format("The new name of the project '%s' could not be saved.", project.getConfiguration().getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The project keeps its old name."});
                NaviErrorDialog.show(null, "E00174: Could not save project name", innerDescription, e2);
            }
        } else if (col == 1) {
            try {
                project.getConfiguration().setDescription((String)value);
            }
            catch (CouldntSaveDataException e3) {
                CUtilityFunctions.logException(e3);
                String innerMessage = "E00175: Could not save project description";
                String innerDescription = CUtilityFunctions.createDescription(String.format("The new description of the project '%s' could not be saved.", project.getConfiguration().getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The project keeps its old description."});
                NaviErrorDialog.show(null, "E00175: Could not save project description", innerDescription, e3);
            }
        }
    }

    private class InternalProjectListener
    extends CProjectListenerAdapter {
        private InternalProjectListener() {
        }

        @Override
        public void changedDescription(INaviProject project, String description) {
            CProjectsModel.this.m_cachedValues = null;
            CProjectsModel.this.fireTableDataChanged();
        }

        @Override
        public void changedModificationDate(INaviProject project, Date date) {
            CProjectsModel.this.m_cachedValues = null;
            CProjectsModel.this.fireTableDataChanged();
        }

        @Override
        public void changedName(INaviProject project, String name) {
            CProjectsModel.this.m_cachedValues = null;
            CProjectsModel.this.fireTableDataChanged();
        }

        @Override
        public void loadedProject(CProject project) {
            CProjectsModel.this.m_cachedValues = null;
            CProjectsModel.this.fireTableDataChanged();
        }
    }

    private class InternalDatabaseListener
    extends CDatabaseListenerAdapter {
        private InternalDatabaseListener() {
        }

        @Override
        public void addedProject(IDatabase connection, INaviProject newProject) {
            CProjectsModel.this.m_cachedValues = null;
            newProject.addListener(CProjectsModel.this.m_projectListener);
            CProjectsModel.this.fireTableDataChanged();
        }

        @Override
        public void deletedProject(IDatabase database, INaviProject project) {
            CProjectsModel.this.m_cachedValues = null;
            project.removeListener(CProjectsModel.this.m_projectListener);
            CProjectsModel.this.fireTableDataChanged();
        }
    }
}

