/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Project.Component;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.IFilter;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractTreeTableModel;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.CAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.CAddressSpaceConfigurationListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.CAddressSpaceListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.CProject;
import com.google.security.zynamics.binnavi.disassembly.CProjectListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.INaviAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.INaviProject;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public final class CAddressSpacesModel
extends CAbstractTreeTableModel<INaviAddressSpace> {
    private static final long serialVersionUID = -1003200350051243176L;
    private static final int NAME_COLUMN = 0;
    private static final int DESCRIPTION_COLUMN = 1;
    private static final int MODULES_COLUMN = 2;
    private static final int CREATION_DATE_COLUMN = 3;
    private static final int MODIFICATION_DATE_COLUMN = 4;
    private final String[] COLUMNS = new String[]{"Name", "Description", "Modules", "Creation Date", "Modification Date"};
    private final INaviProject m_project;
    private final InternalProjectListener m_projectListener = new InternalProjectListener();
    private final InternalAddressSpaceListener m_addressSpaceListener = new InternalAddressSpaceListener();
    private final InternalAddressSpaceConfigurationListener m_addressSpaceConfigurationListener = new InternalAddressSpaceConfigurationListener();
    private List<INaviAddressSpace> m_cachedValues = null;

    public CAddressSpacesModel(INaviProject project) {
        this.m_project = Preconditions.checkNotNull(project, "IE01984: Project argument can't be null");
        project.addListener(this.m_projectListener);
        if (project.isLoaded()) {
            for (INaviAddressSpace addressSpace : project.getContent().getAddressSpaces()) {
                addressSpace.addListener(this.m_addressSpaceListener);
                addressSpace.getConfiguration().addListener(this.m_addressSpaceConfigurationListener);
            }
        }
    }

    @Override
    public void delete() {
        this.m_project.removeListener(this.m_projectListener);
        if (this.m_project.isLoaded()) {
            for (INaviAddressSpace addressSpace : this.m_project.getContent().getAddressSpaces()) {
                addressSpace.removeListener(this.m_addressSpaceListener);
                addressSpace.getConfiguration().removeListener(this.m_addressSpaceConfigurationListener);
            }
        }
    }

    public List<INaviAddressSpace> getAddressSpaces() {
        List<INaviAddressSpace> localCachedValues = this.m_cachedValues;
        if (localCachedValues == null) {
            IFilter<INaviAddressSpace> filter = this.getFilter();
            localCachedValues = this.m_project.isLoaded() ? (filter == null ? this.m_project.getContent().getAddressSpaces() : filter.get(this.m_project.getContent().getAddressSpaces())) : new ArrayList<INaviAddressSpace>();
        }
        this.m_cachedValues = localCachedValues;
        return new ArrayList<INaviAddressSpace>(localCachedValues);
    }

    @Override
    public int getColumnCount() {
        return this.COLUMNS.length;
    }

    @Override
    public String getColumnName(int index) {
        return this.COLUMNS[index];
    }

    @Override
    public int getRowCount() {
        return this.getAddressSpaces().size();
    }

    @Override
    public List<Pair<Integer, Comparator<?>>> getSorters() {
        return new ArrayList();
    }

    @Override
    public Object getValueAt(int row, int col) {
        INaviAddressSpace addressSpace = this.getAddressSpaces().get(row);
        switch (col) {
            case 0: {
                return addressSpace.getConfiguration().getName();
            }
            case 1: {
                return addressSpace.getConfiguration().getDescription();
            }
            case 2: {
                return addressSpace.isLoaded() ? Integer.valueOf(addressSpace.getContent().getModules().size()) : "?";
            }
            case 3: {
                return addressSpace.getConfiguration().getCreationDate();
            }
            case 4: {
                return addressSpace.getConfiguration().getModificationDate();
            }
        }
        throw new IllegalStateException("IE01169: Invalid column");
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 0 || col == 1;
    }

    @Override
    public void setFilter(IFilter<INaviAddressSpace> filter) {
        this.m_cachedValues = null;
        super.setFilter(filter);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col != 0 && col != 1) {
            throw new IllegalStateException("IE01170: Column can not be edited");
        }
        INaviAddressSpace addressSpace = this.getAddressSpaces().get(row);
        if (col == 0) {
            try {
                addressSpace.getConfiguration().setName((String)value);
            }
            catch (CouldntSaveDataException e2) {
                CUtilityFunctions.logException(e2);
                String innerMessage = "E00169: Could not save address space name";
                String innerDescription = CUtilityFunctions.createDescription(String.format("The new name of the address space '%s' could not be saved.", addressSpace.getConfiguration().getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The address space keeps its old name."});
                NaviErrorDialog.show(null, "E00169: Could not save address space name", innerDescription, e2);
            }
        } else if (col == 1) {
            try {
                addressSpace.getConfiguration().setDescription((String)value);
            }
            catch (CouldntSaveDataException e3) {
                CUtilityFunctions.logException(e3);
                String innerMessage = "E00170: Could not save address space description";
                String innerDescription = CUtilityFunctions.createDescription(String.format("The new description of the address space '%s' could not be saved.", addressSpace.getConfiguration().getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The address space keeps its old description."});
                NaviErrorDialog.show(null, "E00170: Could not save address space description", innerDescription, e3);
            }
        }
    }

    private class InternalProjectListener
    extends CProjectListenerAdapter {
        private InternalProjectListener() {
        }

        @Override
        public void addedAddressSpace(INaviProject project, CAddressSpace space) {
            CAddressSpacesModel.this.m_cachedValues = null;
            space.addListener(CAddressSpacesModel.this.m_addressSpaceListener);
            space.getConfiguration().addListener(CAddressSpacesModel.this.m_addressSpaceConfigurationListener);
            CAddressSpacesModel.this.fireTableDataChanged();
        }

        @Override
        public void loadedProject(CProject project) {
            CAddressSpacesModel.this.m_cachedValues = null;
            for (INaviAddressSpace addressSpace : project.getContent().getAddressSpaces()) {
                addressSpace.addListener(CAddressSpacesModel.this.m_addressSpaceListener);
                addressSpace.getConfiguration().addListener(CAddressSpacesModel.this.m_addressSpaceConfigurationListener);
            }
            CAddressSpacesModel.this.fireTableDataChanged();
        }

        @Override
        public void removedAddressSpace(INaviProject project, INaviAddressSpace space) {
            CAddressSpacesModel.this.m_cachedValues = null;
            space.removeListener(CAddressSpacesModel.this.m_addressSpaceListener);
            space.getConfiguration().removeListener(CAddressSpacesModel.this.m_addressSpaceConfigurationListener);
            CAddressSpacesModel.this.fireTableDataChanged();
        }
    }

    private class InternalAddressSpaceListener
    extends CAddressSpaceListenerAdapter {
        private InternalAddressSpaceListener() {
        }

        @Override
        public void loaded(INaviAddressSpace addressSpace) {
            CAddressSpacesModel.this.m_cachedValues = null;
            CAddressSpacesModel.this.fireTableDataChanged();
        }
    }

    private class InternalAddressSpaceConfigurationListener
    extends CAddressSpaceConfigurationListenerAdapter {
        private InternalAddressSpaceConfigurationListener() {
        }

        @Override
        public void changedDescription(INaviAddressSpace addressSpace, String description) {
            CAddressSpacesModel.this.m_cachedValues = null;
            CAddressSpacesModel.this.fireTableDataChanged();
        }

        @Override
        public void changedName(INaviAddressSpace addressSpace, String name) {
            CAddressSpacesModel.this.m_cachedValues = null;
            CAddressSpacesModel.this.fireTableDataChanged();
        }
    }
}

