/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.ModuleContainer.Component;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.HotKeys;
import com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations.CModuleFunctions;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.DragAndDrop.CModuleDragHandler;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractTreeTable;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CLoadedRenderer;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Module.CModuleNodeMenuBuilder;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.ModuleContainer.Component.CModuleNameLabel;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.ModuleContainer.Component.CModulesModel;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.ModuleContainer.Component.Help.CModulesTableHelp;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Updaters.CEmptyUpdater;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.Modules.CModule;
import java.awt.Color;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.DefaultTableCellRenderer;

public final class CModulesTable
extends CAbstractTreeTable<INaviModule> {
    private static final long serialVersionUID = 7323735951997220913L;
    private final IDatabase m_database;

    public CModulesTable(JTree projectTree, IDatabase database) {
        super(projectTree, new CModulesModel(database), new CModulesTableHelp());
        this.m_database = Preconditions.checkNotNull(database, "IE02870: database argument can not be null");
        this.setDefaultRenderer(Object.class, new ModuleLoadedRenderer());
        this.getColumnModel().getColumn(1).setCellRenderer(new CNameRenderer());
        this.getColumnModel().getColumn(0).setResizable(false);
        this.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.getColumnModel().getColumn(0).setMaxWidth(50);
        if (!GraphicsEnvironment.isHeadless()) {
            this.setDragEnabled(true);
        }
        this.setTransferHandler(new CModuleDragHandler(this));
        InputMap windowImap = this.getInputMap(0);
        windowImap.put(HotKeys.LOAD_HK.getKeyStroke(), "LoadKeyStroke");
        this.getActionMap().put("LoadKeyStroke", CActionProxy.proxy(new LoadModuleAction()));
    }

    private INaviModule[] getModules(int[] sortSelectedRows) {
        INaviModule[] modules = new CModule[sortSelectedRows.length];
        for (int i2 = 0; i2 < modules.length; ++i2) {
            modules[i2] = this.getTreeTableModel().getModules().get(sortSelectedRows[i2]);
        }
        return modules;
    }

    private INaviModule[] getSelectedModules(int sortedRow) {
        int[] sortSelectedRows = this.getSortSelectedRows();
        if (Ints.asList(sortSelectedRows).indexOf(sortedRow) != -1) {
            return this.getModules(sortSelectedRows);
        }
        int viewRow = this.convertRowIndexToView(sortedRow);
        this.setRowSelectionInterval(viewRow, viewRow);
        return new INaviModule[]{this.getTreeTableModel().getModules().get(sortedRow)};
    }

    private INaviModule[] getUnloadedModules(INaviModule[] modules) {
        ArrayList<INaviModule> unloadedModules = new ArrayList<INaviModule>();
        for (INaviModule module : modules) {
            if (!module.getConfiguration().getRawModule().isComplete() || module.isLoaded()) continue;
            unloadedModules.add(module);
        }
        return unloadedModules.toArray(new INaviModule[0]);
    }

    @Override
    protected void deleteRows() {
        CModuleFunctions.deleteModules(this.getParentWindow(), this.m_database, this.getModules(this.getSortSelectedRows()), new CEmptyUpdater());
    }

    @Override
    protected JPopupMenu getPopupMenu(int x2, int y2, int row) {
        CModuleNodeMenuBuilder menu = new CModuleNodeMenuBuilder(this.getProjectTree(), null, this.m_database, null, this.getSelectedModules(row), this);
        return menu.getPopupMenu();
    }

    @Override
    protected void handleDoubleClick(int row) {
    }

    @Override
    public CModulesModel getTreeTableModel() {
        return (CModulesModel)super.getTreeTableModel();
    }

    private class ModuleLoadedRenderer
    extends CLoadedRenderer {
        private static final long serialVersionUID = -2926632553462013220L;

        private ModuleLoadedRenderer() {
        }

        @Override
        public boolean isLoaded(int row) {
            return CModulesTable.this.getModules(new int[]{CModulesTable.this.convertRowIndexToModel(row)})[0].isLoaded();
        }
    }

    private class LoadModuleAction
    extends AbstractAction {
        private static final long serialVersionUID = 3649209251674113287L;

        private LoadModuleAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CModuleFunctions.loadModules(CModulesTable.this.getProjectTree(), CModulesTable.this.getUnloadedModules(CModulesTable.this.getModules(CModulesTable.this.getSortSelectedRows())));
        }
    }

    private class CNameRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -5822178069477234135L;

        private CNameRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return new CModuleNameLabel(CModulesTable.this, CModulesTable.this.getModules(new int[]{CModulesTable.this.convertRowIndexToModel(row)})[0], isSelected ? table.getSelectionBackground() : Color.WHITE);
        }
    }
}

