/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Module.Component;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.IDebuggerContainer;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.IDebuggerContainerListener;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplate;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplateManager;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebuggerTemplateManagerListener;
import java.util.ArrayList;
import java.util.List;

public final class CDatabaseDebuggerContainer
implements IDebuggerContainer {
    private final IDatabase m_database;
    private final List<ListenerWrapper> m_wrappers = new ArrayList<ListenerWrapper>();

    public CDatabaseDebuggerContainer(IDatabase database) {
        this.m_database = Preconditions.checkNotNull(database, "IE01976: Database argument can not be null");
    }

    @Override
    public void addListener(IDebuggerContainerListener listener) {
        ListenerWrapper wrapper = new ListenerWrapper(listener);
        this.m_database.getContent().getDebuggerTemplateManager().addListener(wrapper);
        this.m_wrappers.add(wrapper);
    }

    public void dispose() {
        for (ListenerWrapper wrapper : this.m_wrappers) {
            this.m_database.getContent().getDebuggerTemplateManager().removeListener(wrapper);
        }
    }

    @Override
    public List<DebuggerTemplate> getDebuggers() {
        return this.m_database.getContent().getDebuggerTemplateManager().getDebuggers();
    }

    private class ListenerWrapper
    implements IDebuggerTemplateManagerListener {
        private final IDebuggerContainerListener m_listener;

        private ListenerWrapper(IDebuggerContainerListener listener) {
            this.m_listener = listener;
        }

        @Override
        public void addedDebugger(DebuggerTemplateManager manager, DebuggerTemplate debugger) {
            this.m_listener.addedDebugger(CDatabaseDebuggerContainer.this, debugger);
        }

        @Override
        public void removedDebugger(DebuggerTemplateManager manager, DebuggerTemplate debugger) {
            this.m_listener.removedDebugger(CDatabaseDebuggerContainer.this, debugger);
        }
    }
}

