/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Module;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CMain;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations.CModuleFunctions;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractLazyComponent;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractNodeComponent;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CProjectTreeNode;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Module.CModuleNodeMenuBuilder;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Module.Component.CModuleNodeComponent;
import com.google.security.zynamics.binnavi.disassembly.CProjectContainer;
import com.google.security.zynamics.binnavi.disassembly.INaviAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.Modules.CModuleContainer;
import com.google.security.zynamics.binnavi.disassembly.Modules.CModuleListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainer;
import com.google.security.zynamics.zylib.gui.SwingInvoker;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public final class CModuleNode
extends CProjectTreeNode<INaviModule> {
    private static final long serialVersionUID = -5643276356053733957L;
    private static final ImageIcon ICON_MODULE = new ImageIcon(CMain.class.getResource("data/projecttreeicons/project_module.png"));
    private static final ImageIcon ICON_MODULE_GRAY = new ImageIcon(CMain.class.getResource("data/projecttreeicons/project_module_gray.png"));
    private static final ImageIcon ICON_MODULE_BROKEN = new ImageIcon(CMain.class.getResource("data/projecttreeicons/project_module_broken.png"));
    private static final ImageIcon ICON_MODULE_UNCONVERTED = new ImageIcon(CMain.class.getResource("data/projecttreeicons/project_module_light_gray.png"));
    private final INaviModule m_module;
    private final IViewContainer m_contextContainer;
    private final InternalModuleListener m_listener;

    public CModuleNode(final JTree projectTree, DefaultMutableTreeNode parentNode, final IDatabase database, final INaviAddressSpace addressSpace, final INaviModule module, final CProjectContainer contextContainer) {
        super(projectTree, new CAbstractLazyComponent(){

            @Override
            protected CAbstractNodeComponent createComponent() {
                return new CModuleNodeComponent(projectTree, database, addressSpace, module, contextContainer);
            }
        }, new CModuleNodeMenuBuilder(projectTree, parentNode, database, addressSpace, new INaviModule[]{module}, null), module);
        Preconditions.checkNotNull(database, "IE01972: Database argument can't be null");
        Preconditions.checkNotNull(addressSpace, "IE01973: Address space can't be null");
        this.m_module = Preconditions.checkNotNull(module, "IE01974: Module can't be null");
        this.m_contextContainer = contextContainer;
        this.createChildren();
        this.m_listener = new InternalModuleListener();
        this.m_module.addListener(this.m_listener);
    }

    public CModuleNode(final JTree projectTree, DefaultMutableTreeNode parentNode, final IDatabase database, final INaviModule module, final CModuleContainer contextContainer) {
        super(projectTree, new CAbstractLazyComponent(){

            @Override
            protected CAbstractNodeComponent createComponent() {
                return new CModuleNodeComponent(projectTree, database, null, module, contextContainer);
            }
        }, new CModuleNodeMenuBuilder(projectTree, parentNode, database, null, new INaviModule[]{module}, null), module);
        Preconditions.checkNotNull(database, "IE01970: Database can't be null");
        this.m_module = Preconditions.checkNotNull(module, "IE01971: Module can't be null");
        this.m_contextContainer = contextContainer;
        this.createChildren();
        this.m_listener = new InternalModuleListener();
        this.m_module.addListener(this.m_listener);
    }

    @Override
    protected void createChildren() {
    }

    @Override
    public void dispose() {
        super.dispose();
        this.m_contextContainer.dispose();
        this.m_module.removeListener(this.m_listener);
        this.deleteChildren();
    }

    @Override
    public void doubleClicked() {
        if (this.m_module.getConfiguration().getRawModule().isComplete() && !this.m_module.isLoaded()) {
            CModuleFunctions.loadModules(this.getProjectTree(), new INaviModule[]{this.m_module});
        }
    }

    @Override
    public CModuleNodeComponent getComponent() {
        return (CModuleNodeComponent)super.getComponent();
    }

    @Override
    public Icon getIcon() {
        if (this.m_module.getConfiguration().getRawModule().isComplete() && this.m_module.isInitialized()) {
            return this.m_module.isLoaded() ? ICON_MODULE : ICON_MODULE_GRAY;
        }
        if (this.m_module.getConfiguration().getRawModule().isComplete() && !this.m_module.isInitialized()) {
            return ICON_MODULE_UNCONVERTED;
        }
        return ICON_MODULE_BROKEN;
    }

    @Override
    public String toString() {
        String string2 = this.m_module.getConfiguration().getName();
        int n2 = this.m_module.getFunctionCount();
        int n3 = this.m_module.getCustomViewCount();
        return new StringBuilder(26 + String.valueOf(string2).length()).append(string2).append(" (").append(n2).append("/").append(n3).append(")").toString();
    }

    private class InternalModuleListener
    extends CModuleListenerAdapter {
        private InternalModuleListener() {
        }

        @Override
        public void addedView(INaviModule module, INaviView view) {
            CModuleNode.this.getTreeModel().nodeChanged(CModuleNode.this);
        }

        @Override
        public void changedName(INaviModule module, String name) {
            CModuleNode.this.getTreeModel().nodeChanged(CModuleNode.this);
        }

        @Override
        public void deletedView(INaviModule module, INaviView view) {
            CModuleNode.this.getTreeModel().nodeChanged(CModuleNode.this);
        }

        @Override
        public void loadedModule(INaviModule module) {
            new SwingInvoker(){

                @Override
                protected void operation() {
                    CModuleNode.this.createChildren();
                    CModuleNode.this.getTreeModel().nodeStructureChanged(CModuleNode.this);
                }
            }.invokeAndWait();
        }
    }
}

